import { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { SNSServiceException as __BaseException } from "./SNSServiceException";
export interface AddPermissionInput {
  TopicArn: string | undefined;
  Label: string | undefined;
  AWSAccountId: string[] | undefined;
  ActionName: string[] | undefined;
}
export declare class AuthorizationErrorException extends __BaseException {
  readonly name: "AuthorizationErrorException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<AuthorizationErrorException, __BaseException>
  );
}
export declare class InternalErrorException extends __BaseException {
  readonly name: "InternalErrorException";
  readonly $fault: "server";
  constructor(
    opts: __ExceptionOptionType<InternalErrorException, __BaseException>
  );
}
export declare class InvalidParameterException extends __BaseException {
  readonly name: "InvalidParameterException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidParameterException, __BaseException>
  );
}
export declare class NotFoundException extends __BaseException {
  readonly name: "NotFoundException";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<NotFoundException, __BaseException>);
}
export interface CheckIfPhoneNumberIsOptedOutInput {
  phoneNumber: string | undefined;
}
export interface CheckIfPhoneNumberIsOptedOutResponse {
  isOptedOut?: boolean;
}
export declare class ThrottledException extends __BaseException {
  readonly name: "ThrottledException";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<ThrottledException, __BaseException>);
}
export interface ConfirmSubscriptionInput {
  TopicArn: string | undefined;
  Token: string | undefined;
  AuthenticateOnUnsubscribe?: string;
}
export interface ConfirmSubscriptionResponse {
  SubscriptionArn?: string;
}
export declare class FilterPolicyLimitExceededException extends __BaseException {
  readonly name: "FilterPolicyLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      FilterPolicyLimitExceededException,
      __BaseException
    >
  );
}
export declare class ReplayLimitExceededException extends __BaseException {
  readonly name: "ReplayLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ReplayLimitExceededException, __BaseException>
  );
}
export declare class SubscriptionLimitExceededException extends __BaseException {
  readonly name: "SubscriptionLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      SubscriptionLimitExceededException,
      __BaseException
    >
  );
}
export interface CreatePlatformApplicationInput {
  Name: string | undefined;
  Platform: string | undefined;
  Attributes: Record<string, string> | undefined;
}
export interface CreatePlatformApplicationResponse {
  PlatformApplicationArn?: string;
}
export interface CreateEndpointResponse {
  EndpointArn?: string;
}
export interface CreatePlatformEndpointInput {
  PlatformApplicationArn: string | undefined;
  Token: string | undefined;
  CustomUserData?: string;
  Attributes?: Record<string, string>;
}
export declare const LanguageCodeString: {
  readonly de_DE: "de-DE";
  readonly en_GB: "en-GB";
  readonly en_US: "en-US";
  readonly es_419: "es-419";
  readonly es_ES: "es-ES";
  readonly fr_CA: "fr-CA";
  readonly fr_FR: "fr-FR";
  readonly it_IT: "it-IT";
  readonly jp_JP: "ja-JP";
  readonly kr_KR: "kr-KR";
  readonly pt_BR: "pt-BR";
  readonly zh_CN: "zh-CN";
  readonly zh_TW: "zh-TW";
};
export type LanguageCodeString =
  (typeof LanguageCodeString)[keyof typeof LanguageCodeString];
export interface CreateSMSSandboxPhoneNumberInput {
  PhoneNumber: string | undefined;
  LanguageCode?: LanguageCodeString;
}
export interface CreateSMSSandboxPhoneNumberResult {}
export declare class OptedOutException extends __BaseException {
  readonly name: "OptedOutException";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<OptedOutException, __BaseException>);
}
export declare class UserErrorException extends __BaseException {
  readonly name: "UserErrorException";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<UserErrorException, __BaseException>);
}
export declare class ConcurrentAccessException extends __BaseException {
  readonly name: "ConcurrentAccessException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ConcurrentAccessException, __BaseException>
  );
}
export interface Tag {
  Key: string | undefined;
  Value: string | undefined;
}
export interface CreateTopicInput {
  Name: string | undefined;
  Attributes?: Record<string, string>;
  Tags?: Tag[];
  DataProtectionPolicy?: string;
}
export interface CreateTopicResponse {
  TopicArn?: string;
}
export declare class InvalidSecurityException extends __BaseException {
  readonly name: "InvalidSecurityException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidSecurityException, __BaseException>
  );
}
export declare class StaleTagException extends __BaseException {
  readonly name: "StaleTagException";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<StaleTagException, __BaseException>);
}
export declare class TagLimitExceededException extends __BaseException {
  readonly name: "TagLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<TagLimitExceededException, __BaseException>
  );
}
export declare class TagPolicyException extends __BaseException {
  readonly name: "TagPolicyException";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<TagPolicyException, __BaseException>);
}
export declare class TopicLimitExceededException extends __BaseException {
  readonly name: "TopicLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<TopicLimitExceededException, __BaseException>
  );
}
export interface DeleteEndpointInput {
  EndpointArn: string | undefined;
}
export interface DeletePlatformApplicationInput {
  PlatformApplicationArn: string | undefined;
}
export interface DeleteSMSSandboxPhoneNumberInput {
  PhoneNumber: string | undefined;
}
export interface DeleteSMSSandboxPhoneNumberResult {}
export declare class ResourceNotFoundException extends __BaseException {
  readonly name: "ResourceNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ResourceNotFoundException, __BaseException>
  );
}
export interface DeleteTopicInput {
  TopicArn: string | undefined;
}
export declare class InvalidStateException extends __BaseException {
  readonly name: "InvalidStateException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidStateException, __BaseException>
  );
}
export interface GetDataProtectionPolicyInput {
  ResourceArn: string | undefined;
}
export interface GetDataProtectionPolicyResponse {
  DataProtectionPolicy?: string;
}
export interface GetEndpointAttributesInput {
  EndpointArn: string | undefined;
}
export interface GetEndpointAttributesResponse {
  Attributes?: Record<string, string>;
}
export interface GetPlatformApplicationAttributesInput {
  PlatformApplicationArn: string | undefined;
}
export interface GetPlatformApplicationAttributesResponse {
  Attributes?: Record<string, string>;
}
export interface GetSMSAttributesInput {
  attributes?: string[];
}
export interface GetSMSAttributesResponse {
  attributes?: Record<string, string>;
}
export interface GetSMSSandboxAccountStatusInput {}
export interface GetSMSSandboxAccountStatusResult {
  IsInSandbox: boolean | undefined;
}
export interface GetSubscriptionAttributesInput {
  SubscriptionArn: string | undefined;
}
export interface GetSubscriptionAttributesResponse {
  Attributes?: Record<string, string>;
}
export interface GetTopicAttributesInput {
  TopicArn: string | undefined;
}
export interface GetTopicAttributesResponse {
  Attributes?: Record<string, string>;
}
export interface ListEndpointsByPlatformApplicationInput {
  PlatformApplicationArn: string | undefined;
  NextToken?: string;
}
export interface Endpoint {
  EndpointArn?: string;
  Attributes?: Record<string, string>;
}
export interface ListEndpointsByPlatformApplicationResponse {
  Endpoints?: Endpoint[];
  NextToken?: string;
}
export interface ListOriginationNumbersRequest {
  NextToken?: string;
  MaxResults?: number;
}
export declare const NumberCapability: {
  readonly MMS: "MMS";
  readonly SMS: "SMS";
  readonly VOICE: "VOICE";
};
export type NumberCapability =
  (typeof NumberCapability)[keyof typeof NumberCapability];
export declare const RouteType: {
  readonly Premium: "Premium";
  readonly Promotional: "Promotional";
  readonly Transactional: "Transactional";
};
export type RouteType = (typeof RouteType)[keyof typeof RouteType];
export interface PhoneNumberInformation {
  CreatedAt?: Date;
  PhoneNumber?: string;
  Status?: string;
  Iso2CountryCode?: string;
  RouteType?: RouteType;
  NumberCapabilities?: NumberCapability[];
}
export interface ListOriginationNumbersResult {
  NextToken?: string;
  PhoneNumbers?: PhoneNumberInformation[];
}
export declare class ValidationException extends __BaseException {
  readonly name: "ValidationException";
  readonly $fault: "client";
  Message: string | undefined;
  constructor(
    opts: __ExceptionOptionType<ValidationException, __BaseException>
  );
}
export interface ListPhoneNumbersOptedOutInput {
  nextToken?: string;
}
export interface ListPhoneNumbersOptedOutResponse {
  phoneNumbers?: string[];
  nextToken?: string;
}
export interface ListPlatformApplicationsInput {
  NextToken?: string;
}
export interface PlatformApplication {
  PlatformApplicationArn?: string;
  Attributes?: Record<string, string>;
}
export interface ListPlatformApplicationsResponse {
  PlatformApplications?: PlatformApplication[];
  NextToken?: string;
}
export interface ListSMSSandboxPhoneNumbersInput {
  NextToken?: string;
  MaxResults?: number;
}
export declare const SMSSandboxPhoneNumberVerificationStatus: {
  readonly Pending: "Pending";
  readonly Verified: "Verified";
};
export type SMSSandboxPhoneNumberVerificationStatus =
  (typeof SMSSandboxPhoneNumberVerificationStatus)[keyof typeof SMSSandboxPhoneNumberVerificationStatus];
export interface SMSSandboxPhoneNumber {
  PhoneNumber?: string;
  Status?: SMSSandboxPhoneNumberVerificationStatus;
}
export interface ListSMSSandboxPhoneNumbersResult {
  PhoneNumbers: SMSSandboxPhoneNumber[] | undefined;
  NextToken?: string;
}
export interface ListSubscriptionsInput {
  NextToken?: string;
}
export interface Subscription {
  SubscriptionArn?: string;
  Owner?: string;
  Protocol?: string;
  Endpoint?: string;
  TopicArn?: string;
}
export interface ListSubscriptionsResponse {
  Subscriptions?: Subscription[];
  NextToken?: string;
}
export interface ListSubscriptionsByTopicInput {
  TopicArn: string | undefined;
  NextToken?: string;
}
export interface ListSubscriptionsByTopicResponse {
  Subscriptions?: Subscription[];
  NextToken?: string;
}
export interface ListTagsForResourceRequest {
  ResourceArn: string | undefined;
}
export interface ListTagsForResourceResponse {
  Tags?: Tag[];
}
export interface ListTopicsInput {
  NextToken?: string;
}
export interface Topic {
  TopicArn?: string;
}
export interface ListTopicsResponse {
  Topics?: Topic[];
  NextToken?: string;
}
export interface OptInPhoneNumberInput {
  phoneNumber: string | undefined;
}
export interface OptInPhoneNumberResponse {}
export declare class EndpointDisabledException extends __BaseException {
  readonly name: "EndpointDisabledException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<EndpointDisabledException, __BaseException>
  );
}
export declare class InvalidParameterValueException extends __BaseException {
  readonly name: "InvalidParameterValueException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidParameterValueException, __BaseException>
  );
}
export declare class KMSAccessDeniedException extends __BaseException {
  readonly name: "KMSAccessDeniedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<KMSAccessDeniedException, __BaseException>
  );
}
export declare class KMSDisabledException extends __BaseException {
  readonly name: "KMSDisabledException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<KMSDisabledException, __BaseException>
  );
}
export declare class KMSInvalidStateException extends __BaseException {
  readonly name: "KMSInvalidStateException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<KMSInvalidStateException, __BaseException>
  );
}
export declare class KMSNotFoundException extends __BaseException {
  readonly name: "KMSNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<KMSNotFoundException, __BaseException>
  );
}
export declare class KMSOptInRequired extends __BaseException {
  readonly name: "KMSOptInRequired";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<KMSOptInRequired, __BaseException>);
}
export declare class KMSThrottlingException extends __BaseException {
  readonly name: "KMSThrottlingException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<KMSThrottlingException, __BaseException>
  );
}
export declare class PlatformApplicationDisabledException extends __BaseException {
  readonly name: "PlatformApplicationDisabledException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      PlatformApplicationDisabledException,
      __BaseException
    >
  );
}
export interface MessageAttributeValue {
  DataType: string | undefined;
  StringValue?: string;
  BinaryValue?: Uint8Array;
}
export interface PublishInput {
  TopicArn?: string;
  TargetArn?: string;
  PhoneNumber?: string;
  Message: string | undefined;
  Subject?: string;
  MessageStructure?: string;
  MessageAttributes?: Record<string, MessageAttributeValue>;
  MessageDeduplicationId?: string;
  MessageGroupId?: string;
}
export interface PublishResponse {
  MessageId?: string;
  SequenceNumber?: string;
}
export declare class BatchEntryIdsNotDistinctException extends __BaseException {
  readonly name: "BatchEntryIdsNotDistinctException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      BatchEntryIdsNotDistinctException,
      __BaseException
    >
  );
}
export declare class BatchRequestTooLongException extends __BaseException {
  readonly name: "BatchRequestTooLongException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<BatchRequestTooLongException, __BaseException>
  );
}
export declare class EmptyBatchRequestException extends __BaseException {
  readonly name: "EmptyBatchRequestException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<EmptyBatchRequestException, __BaseException>
  );
}
export declare class InvalidBatchEntryIdException extends __BaseException {
  readonly name: "InvalidBatchEntryIdException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidBatchEntryIdException, __BaseException>
  );
}
export interface PublishBatchRequestEntry {
  Id: string | undefined;
  Message: string | undefined;
  Subject?: string;
  MessageStructure?: string;
  MessageAttributes?: Record<string, MessageAttributeValue>;
  MessageDeduplicationId?: string;
  MessageGroupId?: string;
}
export interface PublishBatchInput {
  TopicArn: string | undefined;
  PublishBatchRequestEntries: PublishBatchRequestEntry[] | undefined;
}
export interface BatchResultErrorEntry {
  Id: string | undefined;
  Code: string | undefined;
  Message?: string;
  SenderFault: boolean | undefined;
}
export interface PublishBatchResultEntry {
  Id?: string;
  MessageId?: string;
  SequenceNumber?: string;
}
export interface PublishBatchResponse {
  Successful?: PublishBatchResultEntry[];
  Failed?: BatchResultErrorEntry[];
}
export declare class TooManyEntriesInBatchRequestException extends __BaseException {
  readonly name: "TooManyEntriesInBatchRequestException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      TooManyEntriesInBatchRequestException,
      __BaseException
    >
  );
}
export interface PutDataProtectionPolicyInput {
  ResourceArn: string | undefined;
  DataProtectionPolicy: string | undefined;
}
export interface RemovePermissionInput {
  TopicArn: string | undefined;
  Label: string | undefined;
}
export interface SetEndpointAttributesInput {
  EndpointArn: string | undefined;
  Attributes: Record<string, string> | undefined;
}
export interface SetPlatformApplicationAttributesInput {
  PlatformApplicationArn: string | undefined;
  Attributes: Record<string, string> | undefined;
}
export interface SetSMSAttributesInput {
  attributes: Record<string, string> | undefined;
}
export interface SetSMSAttributesResponse {}
export interface SetSubscriptionAttributesInput {
  SubscriptionArn: string | undefined;
  AttributeName: string | undefined;
  AttributeValue?: string;
}
export interface SetTopicAttributesInput {
  TopicArn: string | undefined;
  AttributeName: string | undefined;
  AttributeValue?: string;
}
export interface SubscribeInput {
  TopicArn: string | undefined;
  Protocol: string | undefined;
  Endpoint?: string;
  Attributes?: Record<string, string>;
  ReturnSubscriptionArn?: boolean;
}
export interface SubscribeResponse {
  SubscriptionArn?: string;
}
export interface TagResourceRequest {
  ResourceArn: string | undefined;
  Tags: Tag[] | undefined;
}
export interface TagResourceResponse {}
export interface UnsubscribeInput {
  SubscriptionArn: string | undefined;
}
export interface UntagResourceRequest {
  ResourceArn: string | undefined;
  TagKeys: string[] | undefined;
}
export interface UntagResourceResponse {}
export declare class VerificationException extends __BaseException {
  readonly name: "VerificationException";
  readonly $fault: "client";
  Message: string | undefined;
  Status: string | undefined;
  constructor(
    opts: __ExceptionOptionType<VerificationException, __BaseException>
  );
}
export interface VerifySMSSandboxPhoneNumberInput {
  PhoneNumber: string | undefined;
  OneTimePassword: string | undefined;
}
export interface VerifySMSSandboxPhoneNumberResult {}
