"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SendMessageBatchCommand = exports.$Command = void 0;
const middleware_sdk_sqs_1 = require("@aws-sdk/middleware-sdk-sqs");
const middleware_endpoint_1 = require("@smithy/middleware-endpoint");
const middleware_serde_1 = require("@smithy/middleware-serde");
const smithy_client_1 = require("@smithy/smithy-client");
Object.defineProperty(exports, "$Command", { enumerable: true, get: function () { return smithy_client_1.Command; } });
const types_1 = require("@smithy/types");
const Aws_json1_0_1 = require("../protocols/Aws_json1_0");
class SendMessageBatchCommand extends smithy_client_1.Command {
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    constructor(input) {
        super();
        this.input = input;
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, SendMessageBatchCommand.getEndpointParameterInstructions()));
        this.middlewareStack.use((0, middleware_sdk_sqs_1.getSendMessageBatchPlugin)(configuration));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SQSClient";
        const commandName = "SendMessageBatchCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: (_) => _,
            outputFilterSensitiveLog: (_) => _,
            [types_1.SMITHY_CONTEXT_KEY]: {
                service: "AmazonSQS",
                operation: "SendMessageBatch",
            },
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return (0, Aws_json1_0_1.se_SendMessageBatchCommand)(input, context);
    }
    deserialize(output, context) {
        return (0, Aws_json1_0_1.de_SendMessageBatchCommand)(output, context);
    }
}
exports.SendMessageBatchCommand = SendMessageBatchCommand;
