"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BatchRequestTooLong = exports.MessageSystemAttributeNameForSends = exports.InvalidMessageContents = exports.MessageSystemAttributeName = exports.KmsThrottled = exports.KmsOptInRequired = exports.KmsNotFound = exports.KmsInvalidState = exports.KmsInvalidKeyUsage = exports.KmsDisabled = exports.KmsAccessDenied = exports.PurgeQueueInProgress = exports.InvalidIdFormat = exports.QueueNameExists = exports.QueueDeletedRecently = exports.InvalidAttributeValue = exports.InvalidAttributeName = exports.QueueAttributeName = exports.TooManyEntriesInBatchRequest = exports.InvalidBatchEntryId = exports.EmptyBatchRequest = exports.BatchEntryIdsNotDistinct = exports.ReceiptHandleIsInvalid = exports.MessageNotInflight = exports.ResourceNotFoundException = exports.UnsupportedOperation = exports.RequestThrottled = exports.QueueDoesNotExist = exports.OverLimit = exports.InvalidSecurity = exports.InvalidAddress = void 0;
const SQSServiceException_1 = require("./SQSServiceException");
class InvalidAddress extends SQSServiceException_1.SQSServiceException {
    constructor(opts) {
        super({
            name: "InvalidAddress",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidAddress";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidAddress.prototype);
    }
}
exports.InvalidAddress = InvalidAddress;
class InvalidSecurity extends SQSServiceException_1.SQSServiceException {
    constructor(opts) {
        super({
            name: "InvalidSecurity",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidSecurity";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidSecurity.prototype);
    }
}
exports.InvalidSecurity = InvalidSecurity;
class OverLimit extends SQSServiceException_1.SQSServiceException {
    constructor(opts) {
        super({
            name: "OverLimit",
            $fault: "client",
            ...opts,
        });
        this.name = "OverLimit";
        this.$fault = "client";
        Object.setPrototypeOf(this, OverLimit.prototype);
    }
}
exports.OverLimit = OverLimit;
class QueueDoesNotExist extends SQSServiceException_1.SQSServiceException {
    constructor(opts) {
        super({
            name: "QueueDoesNotExist",
            $fault: "client",
            ...opts,
        });
        this.name = "QueueDoesNotExist";
        this.$fault = "client";
        Object.setPrototypeOf(this, QueueDoesNotExist.prototype);
    }
}
exports.QueueDoesNotExist = QueueDoesNotExist;
class RequestThrottled extends SQSServiceException_1.SQSServiceException {
    constructor(opts) {
        super({
            name: "RequestThrottled",
            $fault: "client",
            ...opts,
        });
        this.name = "RequestThrottled";
        this.$fault = "client";
        Object.setPrototypeOf(this, RequestThrottled.prototype);
    }
}
exports.RequestThrottled = RequestThrottled;
class UnsupportedOperation extends SQSServiceException_1.SQSServiceException {
    constructor(opts) {
        super({
            name: "UnsupportedOperation",
            $fault: "client",
            ...opts,
        });
        this.name = "UnsupportedOperation";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnsupportedOperation.prototype);
    }
}
exports.UnsupportedOperation = UnsupportedOperation;
class ResourceNotFoundException extends SQSServiceException_1.SQSServiceException {
    constructor(opts) {
        super({
            name: "ResourceNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceNotFoundException.prototype);
    }
}
exports.ResourceNotFoundException = ResourceNotFoundException;
class MessageNotInflight extends SQSServiceException_1.SQSServiceException {
    constructor(opts) {
        super({
            name: "MessageNotInflight",
            $fault: "client",
            ...opts,
        });
        this.name = "MessageNotInflight";
        this.$fault = "client";
        Object.setPrototypeOf(this, MessageNotInflight.prototype);
    }
}
exports.MessageNotInflight = MessageNotInflight;
class ReceiptHandleIsInvalid extends SQSServiceException_1.SQSServiceException {
    constructor(opts) {
        super({
            name: "ReceiptHandleIsInvalid",
            $fault: "client",
            ...opts,
        });
        this.name = "ReceiptHandleIsInvalid";
        this.$fault = "client";
        Object.setPrototypeOf(this, ReceiptHandleIsInvalid.prototype);
    }
}
exports.ReceiptHandleIsInvalid = ReceiptHandleIsInvalid;
class BatchEntryIdsNotDistinct extends SQSServiceException_1.SQSServiceException {
    constructor(opts) {
        super({
            name: "BatchEntryIdsNotDistinct",
            $fault: "client",
            ...opts,
        });
        this.name = "BatchEntryIdsNotDistinct";
        this.$fault = "client";
        Object.setPrototypeOf(this, BatchEntryIdsNotDistinct.prototype);
    }
}
exports.BatchEntryIdsNotDistinct = BatchEntryIdsNotDistinct;
class EmptyBatchRequest extends SQSServiceException_1.SQSServiceException {
    constructor(opts) {
        super({
            name: "EmptyBatchRequest",
            $fault: "client",
            ...opts,
        });
        this.name = "EmptyBatchRequest";
        this.$fault = "client";
        Object.setPrototypeOf(this, EmptyBatchRequest.prototype);
    }
}
exports.EmptyBatchRequest = EmptyBatchRequest;
class InvalidBatchEntryId extends SQSServiceException_1.SQSServiceException {
    constructor(opts) {
        super({
            name: "InvalidBatchEntryId",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidBatchEntryId";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidBatchEntryId.prototype);
    }
}
exports.InvalidBatchEntryId = InvalidBatchEntryId;
class TooManyEntriesInBatchRequest extends SQSServiceException_1.SQSServiceException {
    constructor(opts) {
        super({
            name: "TooManyEntriesInBatchRequest",
            $fault: "client",
            ...opts,
        });
        this.name = "TooManyEntriesInBatchRequest";
        this.$fault = "client";
        Object.setPrototypeOf(this, TooManyEntriesInBatchRequest.prototype);
    }
}
exports.TooManyEntriesInBatchRequest = TooManyEntriesInBatchRequest;
exports.QueueAttributeName = {
    All: "All",
    ApproximateNumberOfMessages: "ApproximateNumberOfMessages",
    ApproximateNumberOfMessagesDelayed: "ApproximateNumberOfMessagesDelayed",
    ApproximateNumberOfMessagesNotVisible: "ApproximateNumberOfMessagesNotVisible",
    ContentBasedDeduplication: "ContentBasedDeduplication",
    CreatedTimestamp: "CreatedTimestamp",
    DeduplicationScope: "DeduplicationScope",
    DelaySeconds: "DelaySeconds",
    FifoQueue: "FifoQueue",
    FifoThroughputLimit: "FifoThroughputLimit",
    KmsDataKeyReusePeriodSeconds: "KmsDataKeyReusePeriodSeconds",
    KmsMasterKeyId: "KmsMasterKeyId",
    LastModifiedTimestamp: "LastModifiedTimestamp",
    MaximumMessageSize: "MaximumMessageSize",
    MessageRetentionPeriod: "MessageRetentionPeriod",
    Policy: "Policy",
    QueueArn: "QueueArn",
    ReceiveMessageWaitTimeSeconds: "ReceiveMessageWaitTimeSeconds",
    RedriveAllowPolicy: "RedriveAllowPolicy",
    RedrivePolicy: "RedrivePolicy",
    SqsManagedSseEnabled: "SqsManagedSseEnabled",
    VisibilityTimeout: "VisibilityTimeout",
};
class InvalidAttributeName extends SQSServiceException_1.SQSServiceException {
    constructor(opts) {
        super({
            name: "InvalidAttributeName",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidAttributeName";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidAttributeName.prototype);
    }
}
exports.InvalidAttributeName = InvalidAttributeName;
class InvalidAttributeValue extends SQSServiceException_1.SQSServiceException {
    constructor(opts) {
        super({
            name: "InvalidAttributeValue",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidAttributeValue";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidAttributeValue.prototype);
    }
}
exports.InvalidAttributeValue = InvalidAttributeValue;
class QueueDeletedRecently extends SQSServiceException_1.SQSServiceException {
    constructor(opts) {
        super({
            name: "QueueDeletedRecently",
            $fault: "client",
            ...opts,
        });
        this.name = "QueueDeletedRecently";
        this.$fault = "client";
        Object.setPrototypeOf(this, QueueDeletedRecently.prototype);
    }
}
exports.QueueDeletedRecently = QueueDeletedRecently;
class QueueNameExists extends SQSServiceException_1.SQSServiceException {
    constructor(opts) {
        super({
            name: "QueueNameExists",
            $fault: "client",
            ...opts,
        });
        this.name = "QueueNameExists";
        this.$fault = "client";
        Object.setPrototypeOf(this, QueueNameExists.prototype);
    }
}
exports.QueueNameExists = QueueNameExists;
class InvalidIdFormat extends SQSServiceException_1.SQSServiceException {
    constructor(opts) {
        super({
            name: "InvalidIdFormat",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidIdFormat";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidIdFormat.prototype);
    }
}
exports.InvalidIdFormat = InvalidIdFormat;
class PurgeQueueInProgress extends SQSServiceException_1.SQSServiceException {
    constructor(opts) {
        super({
            name: "PurgeQueueInProgress",
            $fault: "client",
            ...opts,
        });
        this.name = "PurgeQueueInProgress";
        this.$fault = "client";
        Object.setPrototypeOf(this, PurgeQueueInProgress.prototype);
    }
}
exports.PurgeQueueInProgress = PurgeQueueInProgress;
class KmsAccessDenied extends SQSServiceException_1.SQSServiceException {
    constructor(opts) {
        super({
            name: "KmsAccessDenied",
            $fault: "client",
            ...opts,
        });
        this.name = "KmsAccessDenied";
        this.$fault = "client";
        Object.setPrototypeOf(this, KmsAccessDenied.prototype);
    }
}
exports.KmsAccessDenied = KmsAccessDenied;
class KmsDisabled extends SQSServiceException_1.SQSServiceException {
    constructor(opts) {
        super({
            name: "KmsDisabled",
            $fault: "client",
            ...opts,
        });
        this.name = "KmsDisabled";
        this.$fault = "client";
        Object.setPrototypeOf(this, KmsDisabled.prototype);
    }
}
exports.KmsDisabled = KmsDisabled;
class KmsInvalidKeyUsage extends SQSServiceException_1.SQSServiceException {
    constructor(opts) {
        super({
            name: "KmsInvalidKeyUsage",
            $fault: "client",
            ...opts,
        });
        this.name = "KmsInvalidKeyUsage";
        this.$fault = "client";
        Object.setPrototypeOf(this, KmsInvalidKeyUsage.prototype);
    }
}
exports.KmsInvalidKeyUsage = KmsInvalidKeyUsage;
class KmsInvalidState extends SQSServiceException_1.SQSServiceException {
    constructor(opts) {
        super({
            name: "KmsInvalidState",
            $fault: "client",
            ...opts,
        });
        this.name = "KmsInvalidState";
        this.$fault = "client";
        Object.setPrototypeOf(this, KmsInvalidState.prototype);
    }
}
exports.KmsInvalidState = KmsInvalidState;
class KmsNotFound extends SQSServiceException_1.SQSServiceException {
    constructor(opts) {
        super({
            name: "KmsNotFound",
            $fault: "client",
            ...opts,
        });
        this.name = "KmsNotFound";
        this.$fault = "client";
        Object.setPrototypeOf(this, KmsNotFound.prototype);
    }
}
exports.KmsNotFound = KmsNotFound;
class KmsOptInRequired extends SQSServiceException_1.SQSServiceException {
    constructor(opts) {
        super({
            name: "KmsOptInRequired",
            $fault: "client",
            ...opts,
        });
        this.name = "KmsOptInRequired";
        this.$fault = "client";
        Object.setPrototypeOf(this, KmsOptInRequired.prototype);
    }
}
exports.KmsOptInRequired = KmsOptInRequired;
class KmsThrottled extends SQSServiceException_1.SQSServiceException {
    constructor(opts) {
        super({
            name: "KmsThrottled",
            $fault: "client",
            ...opts,
        });
        this.name = "KmsThrottled";
        this.$fault = "client";
        Object.setPrototypeOf(this, KmsThrottled.prototype);
    }
}
exports.KmsThrottled = KmsThrottled;
exports.MessageSystemAttributeName = {
    AWSTraceHeader: "AWSTraceHeader",
    ApproximateFirstReceiveTimestamp: "ApproximateFirstReceiveTimestamp",
    ApproximateReceiveCount: "ApproximateReceiveCount",
    DeadLetterQueueSourceArn: "DeadLetterQueueSourceArn",
    MessageDeduplicationId: "MessageDeduplicationId",
    MessageGroupId: "MessageGroupId",
    SenderId: "SenderId",
    SentTimestamp: "SentTimestamp",
    SequenceNumber: "SequenceNumber",
};
class InvalidMessageContents extends SQSServiceException_1.SQSServiceException {
    constructor(opts) {
        super({
            name: "InvalidMessageContents",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidMessageContents";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidMessageContents.prototype);
    }
}
exports.InvalidMessageContents = InvalidMessageContents;
exports.MessageSystemAttributeNameForSends = {
    AWSTraceHeader: "AWSTraceHeader",
};
class BatchRequestTooLong extends SQSServiceException_1.SQSServiceException {
    constructor(opts) {
        super({
            name: "BatchRequestTooLong",
            $fault: "client",
            ...opts,
        });
        this.name = "BatchRequestTooLong";
        this.$fault = "client";
        Object.setPrototypeOf(this, BatchRequestTooLong.prototype);
    }
}
exports.BatchRequestTooLong = BatchRequestTooLong;
