"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.de_UntagQueueCommand = exports.de_TagQueueCommand = exports.de_StartMessageMoveTaskCommand = exports.de_SetQueueAttributesCommand = exports.de_SendMessageBatchCommand = exports.de_SendMessageCommand = exports.de_RemovePermissionCommand = exports.de_ReceiveMessageCommand = exports.de_PurgeQueueCommand = exports.de_ListQueueTagsCommand = exports.de_ListQueuesCommand = exports.de_ListMessageMoveTasksCommand = exports.de_ListDeadLetterSourceQueuesCommand = exports.de_GetQueueUrlCommand = exports.de_GetQueueAttributesCommand = exports.de_DeleteQueueCommand = exports.de_DeleteMessageBatchCommand = exports.de_DeleteMessageCommand = exports.de_CreateQueueCommand = exports.de_ChangeMessageVisibilityBatchCommand = exports.de_ChangeMessageVisibilityCommand = exports.de_CancelMessageMoveTaskCommand = exports.de_AddPermissionCommand = exports.se_UntagQueueCommand = exports.se_TagQueueCommand = exports.se_StartMessageMoveTaskCommand = exports.se_SetQueueAttributesCommand = exports.se_SendMessageBatchCommand = exports.se_SendMessageCommand = exports.se_RemovePermissionCommand = exports.se_ReceiveMessageCommand = exports.se_PurgeQueueCommand = exports.se_ListQueueTagsCommand = exports.se_ListQueuesCommand = exports.se_ListMessageMoveTasksCommand = exports.se_ListDeadLetterSourceQueuesCommand = exports.se_GetQueueUrlCommand = exports.se_GetQueueAttributesCommand = exports.se_DeleteQueueCommand = exports.se_DeleteMessageBatchCommand = exports.se_DeleteMessageCommand = exports.se_CreateQueueCommand = exports.se_ChangeMessageVisibilityBatchCommand = exports.se_ChangeMessageVisibilityCommand = exports.se_CancelMessageMoveTaskCommand = exports.se_AddPermissionCommand = void 0;
const core_1 = require("@aws-sdk/core");
const protocol_http_1 = require("@smithy/protocol-http");
const smithy_client_1 = require("@smithy/smithy-client");
const models_0_1 = require("../models/models_0");
const SQSServiceException_1 = require("../models/SQSServiceException");
const se_AddPermissionCommand = async (input, context) => {
    const headers = sharedHeaders("AddPermission");
    let body;
    body = JSON.stringify(se_AddPermissionRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
exports.se_AddPermissionCommand = se_AddPermissionCommand;
const se_CancelMessageMoveTaskCommand = async (input, context) => {
    const headers = sharedHeaders("CancelMessageMoveTask");
    let body;
    body = JSON.stringify(se_CancelMessageMoveTaskRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
exports.se_CancelMessageMoveTaskCommand = se_CancelMessageMoveTaskCommand;
const se_ChangeMessageVisibilityCommand = async (input, context) => {
    const headers = sharedHeaders("ChangeMessageVisibility");
    let body;
    body = JSON.stringify(se_ChangeMessageVisibilityRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
exports.se_ChangeMessageVisibilityCommand = se_ChangeMessageVisibilityCommand;
const se_ChangeMessageVisibilityBatchCommand = async (input, context) => {
    const headers = sharedHeaders("ChangeMessageVisibilityBatch");
    let body;
    body = JSON.stringify(se_ChangeMessageVisibilityBatchRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
exports.se_ChangeMessageVisibilityBatchCommand = se_ChangeMessageVisibilityBatchCommand;
const se_CreateQueueCommand = async (input, context) => {
    const headers = sharedHeaders("CreateQueue");
    let body;
    body = JSON.stringify(se_CreateQueueRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
exports.se_CreateQueueCommand = se_CreateQueueCommand;
const se_DeleteMessageCommand = async (input, context) => {
    const headers = sharedHeaders("DeleteMessage");
    let body;
    body = JSON.stringify(se_DeleteMessageRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
exports.se_DeleteMessageCommand = se_DeleteMessageCommand;
const se_DeleteMessageBatchCommand = async (input, context) => {
    const headers = sharedHeaders("DeleteMessageBatch");
    let body;
    body = JSON.stringify(se_DeleteMessageBatchRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
exports.se_DeleteMessageBatchCommand = se_DeleteMessageBatchCommand;
const se_DeleteQueueCommand = async (input, context) => {
    const headers = sharedHeaders("DeleteQueue");
    let body;
    body = JSON.stringify(se_DeleteQueueRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
exports.se_DeleteQueueCommand = se_DeleteQueueCommand;
const se_GetQueueAttributesCommand = async (input, context) => {
    const headers = sharedHeaders("GetQueueAttributes");
    let body;
    body = JSON.stringify(se_GetQueueAttributesRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
exports.se_GetQueueAttributesCommand = se_GetQueueAttributesCommand;
const se_GetQueueUrlCommand = async (input, context) => {
    const headers = sharedHeaders("GetQueueUrl");
    let body;
    body = JSON.stringify(se_GetQueueUrlRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
exports.se_GetQueueUrlCommand = se_GetQueueUrlCommand;
const se_ListDeadLetterSourceQueuesCommand = async (input, context) => {
    const headers = sharedHeaders("ListDeadLetterSourceQueues");
    let body;
    body = JSON.stringify(se_ListDeadLetterSourceQueuesRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
exports.se_ListDeadLetterSourceQueuesCommand = se_ListDeadLetterSourceQueuesCommand;
const se_ListMessageMoveTasksCommand = async (input, context) => {
    const headers = sharedHeaders("ListMessageMoveTasks");
    let body;
    body = JSON.stringify(se_ListMessageMoveTasksRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
exports.se_ListMessageMoveTasksCommand = se_ListMessageMoveTasksCommand;
const se_ListQueuesCommand = async (input, context) => {
    const headers = sharedHeaders("ListQueues");
    let body;
    body = JSON.stringify(se_ListQueuesRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
exports.se_ListQueuesCommand = se_ListQueuesCommand;
const se_ListQueueTagsCommand = async (input, context) => {
    const headers = sharedHeaders("ListQueueTags");
    let body;
    body = JSON.stringify(se_ListQueueTagsRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
exports.se_ListQueueTagsCommand = se_ListQueueTagsCommand;
const se_PurgeQueueCommand = async (input, context) => {
    const headers = sharedHeaders("PurgeQueue");
    let body;
    body = JSON.stringify(se_PurgeQueueRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
exports.se_PurgeQueueCommand = se_PurgeQueueCommand;
const se_ReceiveMessageCommand = async (input, context) => {
    const headers = sharedHeaders("ReceiveMessage");
    let body;
    body = JSON.stringify(se_ReceiveMessageRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
exports.se_ReceiveMessageCommand = se_ReceiveMessageCommand;
const se_RemovePermissionCommand = async (input, context) => {
    const headers = sharedHeaders("RemovePermission");
    let body;
    body = JSON.stringify(se_RemovePermissionRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
exports.se_RemovePermissionCommand = se_RemovePermissionCommand;
const se_SendMessageCommand = async (input, context) => {
    const headers = sharedHeaders("SendMessage");
    let body;
    body = JSON.stringify(se_SendMessageRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
exports.se_SendMessageCommand = se_SendMessageCommand;
const se_SendMessageBatchCommand = async (input, context) => {
    const headers = sharedHeaders("SendMessageBatch");
    let body;
    body = JSON.stringify(se_SendMessageBatchRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
exports.se_SendMessageBatchCommand = se_SendMessageBatchCommand;
const se_SetQueueAttributesCommand = async (input, context) => {
    const headers = sharedHeaders("SetQueueAttributes");
    let body;
    body = JSON.stringify(se_SetQueueAttributesRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
exports.se_SetQueueAttributesCommand = se_SetQueueAttributesCommand;
const se_StartMessageMoveTaskCommand = async (input, context) => {
    const headers = sharedHeaders("StartMessageMoveTask");
    let body;
    body = JSON.stringify(se_StartMessageMoveTaskRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
exports.se_StartMessageMoveTaskCommand = se_StartMessageMoveTaskCommand;
const se_TagQueueCommand = async (input, context) => {
    const headers = sharedHeaders("TagQueue");
    let body;
    body = JSON.stringify(se_TagQueueRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
exports.se_TagQueueCommand = se_TagQueueCommand;
const se_UntagQueueCommand = async (input, context) => {
    const headers = sharedHeaders("UntagQueue");
    let body;
    body = JSON.stringify(se_UntagQueueRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
exports.se_UntagQueueCommand = se_UntagQueueCommand;
const de_AddPermissionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_AddPermissionCommandError(output, context);
    }
    await (0, smithy_client_1.collectBody)(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
exports.de_AddPermissionCommand = de_AddPermissionCommand;
const de_AddPermissionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    populateBodyWithQueryCompatibility(parsedOutput, output.headers);
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidAddress":
        case "com.amazonaws.sqs#InvalidAddress":
            throw await de_InvalidAddressRes(parsedOutput, context);
        case "InvalidSecurity":
        case "com.amazonaws.sqs#InvalidSecurity":
            throw await de_InvalidSecurityRes(parsedOutput, context);
        case "OverLimit":
        case "com.amazonaws.sqs#OverLimit":
            throw await de_OverLimitRes(parsedOutput, context);
        case "QueueDoesNotExist":
        case "com.amazonaws.sqs#QueueDoesNotExist":
            throw await de_QueueDoesNotExistRes(parsedOutput, context);
        case "RequestThrottled":
        case "com.amazonaws.sqs#RequestThrottled":
            throw await de_RequestThrottledRes(parsedOutput, context);
        case "UnsupportedOperation":
        case "com.amazonaws.sqs#UnsupportedOperation":
            throw await de_UnsupportedOperationRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_CancelMessageMoveTaskCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CancelMessageMoveTaskCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = (0, smithy_client_1._json)(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
exports.de_CancelMessageMoveTaskCommand = de_CancelMessageMoveTaskCommand;
const de_CancelMessageMoveTaskCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    populateBodyWithQueryCompatibility(parsedOutput, output.headers);
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidAddress":
        case "com.amazonaws.sqs#InvalidAddress":
            throw await de_InvalidAddressRes(parsedOutput, context);
        case "InvalidSecurity":
        case "com.amazonaws.sqs#InvalidSecurity":
            throw await de_InvalidSecurityRes(parsedOutput, context);
        case "RequestThrottled":
        case "com.amazonaws.sqs#RequestThrottled":
            throw await de_RequestThrottledRes(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.sqs#ResourceNotFoundException":
            throw await de_ResourceNotFoundExceptionRes(parsedOutput, context);
        case "UnsupportedOperation":
        case "com.amazonaws.sqs#UnsupportedOperation":
            throw await de_UnsupportedOperationRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_ChangeMessageVisibilityCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ChangeMessageVisibilityCommandError(output, context);
    }
    await (0, smithy_client_1.collectBody)(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
exports.de_ChangeMessageVisibilityCommand = de_ChangeMessageVisibilityCommand;
const de_ChangeMessageVisibilityCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    populateBodyWithQueryCompatibility(parsedOutput, output.headers);
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidAddress":
        case "com.amazonaws.sqs#InvalidAddress":
            throw await de_InvalidAddressRes(parsedOutput, context);
        case "InvalidSecurity":
        case "com.amazonaws.sqs#InvalidSecurity":
            throw await de_InvalidSecurityRes(parsedOutput, context);
        case "MessageNotInflight":
        case "com.amazonaws.sqs#MessageNotInflight":
            throw await de_MessageNotInflightRes(parsedOutput, context);
        case "QueueDoesNotExist":
        case "com.amazonaws.sqs#QueueDoesNotExist":
            throw await de_QueueDoesNotExistRes(parsedOutput, context);
        case "ReceiptHandleIsInvalid":
        case "com.amazonaws.sqs#ReceiptHandleIsInvalid":
            throw await de_ReceiptHandleIsInvalidRes(parsedOutput, context);
        case "RequestThrottled":
        case "com.amazonaws.sqs#RequestThrottled":
            throw await de_RequestThrottledRes(parsedOutput, context);
        case "UnsupportedOperation":
        case "com.amazonaws.sqs#UnsupportedOperation":
            throw await de_UnsupportedOperationRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_ChangeMessageVisibilityBatchCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ChangeMessageVisibilityBatchCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = (0, smithy_client_1._json)(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
exports.de_ChangeMessageVisibilityBatchCommand = de_ChangeMessageVisibilityBatchCommand;
const de_ChangeMessageVisibilityBatchCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    populateBodyWithQueryCompatibility(parsedOutput, output.headers);
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BatchEntryIdsNotDistinct":
        case "com.amazonaws.sqs#BatchEntryIdsNotDistinct":
            throw await de_BatchEntryIdsNotDistinctRes(parsedOutput, context);
        case "EmptyBatchRequest":
        case "com.amazonaws.sqs#EmptyBatchRequest":
            throw await de_EmptyBatchRequestRes(parsedOutput, context);
        case "InvalidAddress":
        case "com.amazonaws.sqs#InvalidAddress":
            throw await de_InvalidAddressRes(parsedOutput, context);
        case "InvalidBatchEntryId":
        case "com.amazonaws.sqs#InvalidBatchEntryId":
            throw await de_InvalidBatchEntryIdRes(parsedOutput, context);
        case "InvalidSecurity":
        case "com.amazonaws.sqs#InvalidSecurity":
            throw await de_InvalidSecurityRes(parsedOutput, context);
        case "QueueDoesNotExist":
        case "com.amazonaws.sqs#QueueDoesNotExist":
            throw await de_QueueDoesNotExistRes(parsedOutput, context);
        case "RequestThrottled":
        case "com.amazonaws.sqs#RequestThrottled":
            throw await de_RequestThrottledRes(parsedOutput, context);
        case "TooManyEntriesInBatchRequest":
        case "com.amazonaws.sqs#TooManyEntriesInBatchRequest":
            throw await de_TooManyEntriesInBatchRequestRes(parsedOutput, context);
        case "UnsupportedOperation":
        case "com.amazonaws.sqs#UnsupportedOperation":
            throw await de_UnsupportedOperationRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_CreateQueueCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CreateQueueCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = (0, smithy_client_1._json)(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
exports.de_CreateQueueCommand = de_CreateQueueCommand;
const de_CreateQueueCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    populateBodyWithQueryCompatibility(parsedOutput, output.headers);
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidAddress":
        case "com.amazonaws.sqs#InvalidAddress":
            throw await de_InvalidAddressRes(parsedOutput, context);
        case "InvalidAttributeName":
        case "com.amazonaws.sqs#InvalidAttributeName":
            throw await de_InvalidAttributeNameRes(parsedOutput, context);
        case "InvalidAttributeValue":
        case "com.amazonaws.sqs#InvalidAttributeValue":
            throw await de_InvalidAttributeValueRes(parsedOutput, context);
        case "InvalidSecurity":
        case "com.amazonaws.sqs#InvalidSecurity":
            throw await de_InvalidSecurityRes(parsedOutput, context);
        case "QueueDeletedRecently":
        case "com.amazonaws.sqs#QueueDeletedRecently":
            throw await de_QueueDeletedRecentlyRes(parsedOutput, context);
        case "QueueNameExists":
        case "com.amazonaws.sqs#QueueNameExists":
            throw await de_QueueNameExistsRes(parsedOutput, context);
        case "RequestThrottled":
        case "com.amazonaws.sqs#RequestThrottled":
            throw await de_RequestThrottledRes(parsedOutput, context);
        case "UnsupportedOperation":
        case "com.amazonaws.sqs#UnsupportedOperation":
            throw await de_UnsupportedOperationRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_DeleteMessageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DeleteMessageCommandError(output, context);
    }
    await (0, smithy_client_1.collectBody)(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
exports.de_DeleteMessageCommand = de_DeleteMessageCommand;
const de_DeleteMessageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    populateBodyWithQueryCompatibility(parsedOutput, output.headers);
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidAddress":
        case "com.amazonaws.sqs#InvalidAddress":
            throw await de_InvalidAddressRes(parsedOutput, context);
        case "InvalidIdFormat":
        case "com.amazonaws.sqs#InvalidIdFormat":
            throw await de_InvalidIdFormatRes(parsedOutput, context);
        case "InvalidSecurity":
        case "com.amazonaws.sqs#InvalidSecurity":
            throw await de_InvalidSecurityRes(parsedOutput, context);
        case "QueueDoesNotExist":
        case "com.amazonaws.sqs#QueueDoesNotExist":
            throw await de_QueueDoesNotExistRes(parsedOutput, context);
        case "ReceiptHandleIsInvalid":
        case "com.amazonaws.sqs#ReceiptHandleIsInvalid":
            throw await de_ReceiptHandleIsInvalidRes(parsedOutput, context);
        case "RequestThrottled":
        case "com.amazonaws.sqs#RequestThrottled":
            throw await de_RequestThrottledRes(parsedOutput, context);
        case "UnsupportedOperation":
        case "com.amazonaws.sqs#UnsupportedOperation":
            throw await de_UnsupportedOperationRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_DeleteMessageBatchCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DeleteMessageBatchCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = (0, smithy_client_1._json)(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
exports.de_DeleteMessageBatchCommand = de_DeleteMessageBatchCommand;
const de_DeleteMessageBatchCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    populateBodyWithQueryCompatibility(parsedOutput, output.headers);
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BatchEntryIdsNotDistinct":
        case "com.amazonaws.sqs#BatchEntryIdsNotDistinct":
            throw await de_BatchEntryIdsNotDistinctRes(parsedOutput, context);
        case "EmptyBatchRequest":
        case "com.amazonaws.sqs#EmptyBatchRequest":
            throw await de_EmptyBatchRequestRes(parsedOutput, context);
        case "InvalidAddress":
        case "com.amazonaws.sqs#InvalidAddress":
            throw await de_InvalidAddressRes(parsedOutput, context);
        case "InvalidBatchEntryId":
        case "com.amazonaws.sqs#InvalidBatchEntryId":
            throw await de_InvalidBatchEntryIdRes(parsedOutput, context);
        case "InvalidSecurity":
        case "com.amazonaws.sqs#InvalidSecurity":
            throw await de_InvalidSecurityRes(parsedOutput, context);
        case "QueueDoesNotExist":
        case "com.amazonaws.sqs#QueueDoesNotExist":
            throw await de_QueueDoesNotExistRes(parsedOutput, context);
        case "RequestThrottled":
        case "com.amazonaws.sqs#RequestThrottled":
            throw await de_RequestThrottledRes(parsedOutput, context);
        case "TooManyEntriesInBatchRequest":
        case "com.amazonaws.sqs#TooManyEntriesInBatchRequest":
            throw await de_TooManyEntriesInBatchRequestRes(parsedOutput, context);
        case "UnsupportedOperation":
        case "com.amazonaws.sqs#UnsupportedOperation":
            throw await de_UnsupportedOperationRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_DeleteQueueCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DeleteQueueCommandError(output, context);
    }
    await (0, smithy_client_1.collectBody)(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
exports.de_DeleteQueueCommand = de_DeleteQueueCommand;
const de_DeleteQueueCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    populateBodyWithQueryCompatibility(parsedOutput, output.headers);
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidAddress":
        case "com.amazonaws.sqs#InvalidAddress":
            throw await de_InvalidAddressRes(parsedOutput, context);
        case "InvalidSecurity":
        case "com.amazonaws.sqs#InvalidSecurity":
            throw await de_InvalidSecurityRes(parsedOutput, context);
        case "QueueDoesNotExist":
        case "com.amazonaws.sqs#QueueDoesNotExist":
            throw await de_QueueDoesNotExistRes(parsedOutput, context);
        case "RequestThrottled":
        case "com.amazonaws.sqs#RequestThrottled":
            throw await de_RequestThrottledRes(parsedOutput, context);
        case "UnsupportedOperation":
        case "com.amazonaws.sqs#UnsupportedOperation":
            throw await de_UnsupportedOperationRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_GetQueueAttributesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_GetQueueAttributesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = (0, smithy_client_1._json)(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
exports.de_GetQueueAttributesCommand = de_GetQueueAttributesCommand;
const de_GetQueueAttributesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    populateBodyWithQueryCompatibility(parsedOutput, output.headers);
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidAddress":
        case "com.amazonaws.sqs#InvalidAddress":
            throw await de_InvalidAddressRes(parsedOutput, context);
        case "InvalidAttributeName":
        case "com.amazonaws.sqs#InvalidAttributeName":
            throw await de_InvalidAttributeNameRes(parsedOutput, context);
        case "InvalidSecurity":
        case "com.amazonaws.sqs#InvalidSecurity":
            throw await de_InvalidSecurityRes(parsedOutput, context);
        case "QueueDoesNotExist":
        case "com.amazonaws.sqs#QueueDoesNotExist":
            throw await de_QueueDoesNotExistRes(parsedOutput, context);
        case "RequestThrottled":
        case "com.amazonaws.sqs#RequestThrottled":
            throw await de_RequestThrottledRes(parsedOutput, context);
        case "UnsupportedOperation":
        case "com.amazonaws.sqs#UnsupportedOperation":
            throw await de_UnsupportedOperationRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_GetQueueUrlCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_GetQueueUrlCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = (0, smithy_client_1._json)(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
exports.de_GetQueueUrlCommand = de_GetQueueUrlCommand;
const de_GetQueueUrlCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    populateBodyWithQueryCompatibility(parsedOutput, output.headers);
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidAddress":
        case "com.amazonaws.sqs#InvalidAddress":
            throw await de_InvalidAddressRes(parsedOutput, context);
        case "InvalidSecurity":
        case "com.amazonaws.sqs#InvalidSecurity":
            throw await de_InvalidSecurityRes(parsedOutput, context);
        case "QueueDoesNotExist":
        case "com.amazonaws.sqs#QueueDoesNotExist":
            throw await de_QueueDoesNotExistRes(parsedOutput, context);
        case "RequestThrottled":
        case "com.amazonaws.sqs#RequestThrottled":
            throw await de_RequestThrottledRes(parsedOutput, context);
        case "UnsupportedOperation":
        case "com.amazonaws.sqs#UnsupportedOperation":
            throw await de_UnsupportedOperationRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_ListDeadLetterSourceQueuesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ListDeadLetterSourceQueuesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = (0, smithy_client_1._json)(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
exports.de_ListDeadLetterSourceQueuesCommand = de_ListDeadLetterSourceQueuesCommand;
const de_ListDeadLetterSourceQueuesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    populateBodyWithQueryCompatibility(parsedOutput, output.headers);
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidAddress":
        case "com.amazonaws.sqs#InvalidAddress":
            throw await de_InvalidAddressRes(parsedOutput, context);
        case "InvalidSecurity":
        case "com.amazonaws.sqs#InvalidSecurity":
            throw await de_InvalidSecurityRes(parsedOutput, context);
        case "QueueDoesNotExist":
        case "com.amazonaws.sqs#QueueDoesNotExist":
            throw await de_QueueDoesNotExistRes(parsedOutput, context);
        case "RequestThrottled":
        case "com.amazonaws.sqs#RequestThrottled":
            throw await de_RequestThrottledRes(parsedOutput, context);
        case "UnsupportedOperation":
        case "com.amazonaws.sqs#UnsupportedOperation":
            throw await de_UnsupportedOperationRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_ListMessageMoveTasksCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ListMessageMoveTasksCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = (0, smithy_client_1._json)(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
exports.de_ListMessageMoveTasksCommand = de_ListMessageMoveTasksCommand;
const de_ListMessageMoveTasksCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    populateBodyWithQueryCompatibility(parsedOutput, output.headers);
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidAddress":
        case "com.amazonaws.sqs#InvalidAddress":
            throw await de_InvalidAddressRes(parsedOutput, context);
        case "InvalidSecurity":
        case "com.amazonaws.sqs#InvalidSecurity":
            throw await de_InvalidSecurityRes(parsedOutput, context);
        case "RequestThrottled":
        case "com.amazonaws.sqs#RequestThrottled":
            throw await de_RequestThrottledRes(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.sqs#ResourceNotFoundException":
            throw await de_ResourceNotFoundExceptionRes(parsedOutput, context);
        case "UnsupportedOperation":
        case "com.amazonaws.sqs#UnsupportedOperation":
            throw await de_UnsupportedOperationRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_ListQueuesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ListQueuesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = (0, smithy_client_1._json)(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
exports.de_ListQueuesCommand = de_ListQueuesCommand;
const de_ListQueuesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    populateBodyWithQueryCompatibility(parsedOutput, output.headers);
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidAddress":
        case "com.amazonaws.sqs#InvalidAddress":
            throw await de_InvalidAddressRes(parsedOutput, context);
        case "InvalidSecurity":
        case "com.amazonaws.sqs#InvalidSecurity":
            throw await de_InvalidSecurityRes(parsedOutput, context);
        case "RequestThrottled":
        case "com.amazonaws.sqs#RequestThrottled":
            throw await de_RequestThrottledRes(parsedOutput, context);
        case "UnsupportedOperation":
        case "com.amazonaws.sqs#UnsupportedOperation":
            throw await de_UnsupportedOperationRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_ListQueueTagsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ListQueueTagsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = (0, smithy_client_1._json)(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
exports.de_ListQueueTagsCommand = de_ListQueueTagsCommand;
const de_ListQueueTagsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    populateBodyWithQueryCompatibility(parsedOutput, output.headers);
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidAddress":
        case "com.amazonaws.sqs#InvalidAddress":
            throw await de_InvalidAddressRes(parsedOutput, context);
        case "InvalidSecurity":
        case "com.amazonaws.sqs#InvalidSecurity":
            throw await de_InvalidSecurityRes(parsedOutput, context);
        case "QueueDoesNotExist":
        case "com.amazonaws.sqs#QueueDoesNotExist":
            throw await de_QueueDoesNotExistRes(parsedOutput, context);
        case "RequestThrottled":
        case "com.amazonaws.sqs#RequestThrottled":
            throw await de_RequestThrottledRes(parsedOutput, context);
        case "UnsupportedOperation":
        case "com.amazonaws.sqs#UnsupportedOperation":
            throw await de_UnsupportedOperationRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_PurgeQueueCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_PurgeQueueCommandError(output, context);
    }
    await (0, smithy_client_1.collectBody)(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
exports.de_PurgeQueueCommand = de_PurgeQueueCommand;
const de_PurgeQueueCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    populateBodyWithQueryCompatibility(parsedOutput, output.headers);
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidAddress":
        case "com.amazonaws.sqs#InvalidAddress":
            throw await de_InvalidAddressRes(parsedOutput, context);
        case "InvalidSecurity":
        case "com.amazonaws.sqs#InvalidSecurity":
            throw await de_InvalidSecurityRes(parsedOutput, context);
        case "PurgeQueueInProgress":
        case "com.amazonaws.sqs#PurgeQueueInProgress":
            throw await de_PurgeQueueInProgressRes(parsedOutput, context);
        case "QueueDoesNotExist":
        case "com.amazonaws.sqs#QueueDoesNotExist":
            throw await de_QueueDoesNotExistRes(parsedOutput, context);
        case "RequestThrottled":
        case "com.amazonaws.sqs#RequestThrottled":
            throw await de_RequestThrottledRes(parsedOutput, context);
        case "UnsupportedOperation":
        case "com.amazonaws.sqs#UnsupportedOperation":
            throw await de_UnsupportedOperationRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_ReceiveMessageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ReceiveMessageCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ReceiveMessageResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
exports.de_ReceiveMessageCommand = de_ReceiveMessageCommand;
const de_ReceiveMessageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    populateBodyWithQueryCompatibility(parsedOutput, output.headers);
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidAddress":
        case "com.amazonaws.sqs#InvalidAddress":
            throw await de_InvalidAddressRes(parsedOutput, context);
        case "InvalidSecurity":
        case "com.amazonaws.sqs#InvalidSecurity":
            throw await de_InvalidSecurityRes(parsedOutput, context);
        case "KmsAccessDenied":
        case "com.amazonaws.sqs#KmsAccessDenied":
            throw await de_KmsAccessDeniedRes(parsedOutput, context);
        case "KmsDisabled":
        case "com.amazonaws.sqs#KmsDisabled":
            throw await de_KmsDisabledRes(parsedOutput, context);
        case "KmsInvalidKeyUsage":
        case "com.amazonaws.sqs#KmsInvalidKeyUsage":
            throw await de_KmsInvalidKeyUsageRes(parsedOutput, context);
        case "KmsInvalidState":
        case "com.amazonaws.sqs#KmsInvalidState":
            throw await de_KmsInvalidStateRes(parsedOutput, context);
        case "KmsNotFound":
        case "com.amazonaws.sqs#KmsNotFound":
            throw await de_KmsNotFoundRes(parsedOutput, context);
        case "KmsOptInRequired":
        case "com.amazonaws.sqs#KmsOptInRequired":
            throw await de_KmsOptInRequiredRes(parsedOutput, context);
        case "KmsThrottled":
        case "com.amazonaws.sqs#KmsThrottled":
            throw await de_KmsThrottledRes(parsedOutput, context);
        case "OverLimit":
        case "com.amazonaws.sqs#OverLimit":
            throw await de_OverLimitRes(parsedOutput, context);
        case "QueueDoesNotExist":
        case "com.amazonaws.sqs#QueueDoesNotExist":
            throw await de_QueueDoesNotExistRes(parsedOutput, context);
        case "RequestThrottled":
        case "com.amazonaws.sqs#RequestThrottled":
            throw await de_RequestThrottledRes(parsedOutput, context);
        case "UnsupportedOperation":
        case "com.amazonaws.sqs#UnsupportedOperation":
            throw await de_UnsupportedOperationRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_RemovePermissionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_RemovePermissionCommandError(output, context);
    }
    await (0, smithy_client_1.collectBody)(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
exports.de_RemovePermissionCommand = de_RemovePermissionCommand;
const de_RemovePermissionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    populateBodyWithQueryCompatibility(parsedOutput, output.headers);
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidAddress":
        case "com.amazonaws.sqs#InvalidAddress":
            throw await de_InvalidAddressRes(parsedOutput, context);
        case "InvalidSecurity":
        case "com.amazonaws.sqs#InvalidSecurity":
            throw await de_InvalidSecurityRes(parsedOutput, context);
        case "QueueDoesNotExist":
        case "com.amazonaws.sqs#QueueDoesNotExist":
            throw await de_QueueDoesNotExistRes(parsedOutput, context);
        case "RequestThrottled":
        case "com.amazonaws.sqs#RequestThrottled":
            throw await de_RequestThrottledRes(parsedOutput, context);
        case "UnsupportedOperation":
        case "com.amazonaws.sqs#UnsupportedOperation":
            throw await de_UnsupportedOperationRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_SendMessageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_SendMessageCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = (0, smithy_client_1._json)(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
exports.de_SendMessageCommand = de_SendMessageCommand;
const de_SendMessageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    populateBodyWithQueryCompatibility(parsedOutput, output.headers);
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidAddress":
        case "com.amazonaws.sqs#InvalidAddress":
            throw await de_InvalidAddressRes(parsedOutput, context);
        case "InvalidMessageContents":
        case "com.amazonaws.sqs#InvalidMessageContents":
            throw await de_InvalidMessageContentsRes(parsedOutput, context);
        case "InvalidSecurity":
        case "com.amazonaws.sqs#InvalidSecurity":
            throw await de_InvalidSecurityRes(parsedOutput, context);
        case "KmsAccessDenied":
        case "com.amazonaws.sqs#KmsAccessDenied":
            throw await de_KmsAccessDeniedRes(parsedOutput, context);
        case "KmsDisabled":
        case "com.amazonaws.sqs#KmsDisabled":
            throw await de_KmsDisabledRes(parsedOutput, context);
        case "KmsInvalidKeyUsage":
        case "com.amazonaws.sqs#KmsInvalidKeyUsage":
            throw await de_KmsInvalidKeyUsageRes(parsedOutput, context);
        case "KmsInvalidState":
        case "com.amazonaws.sqs#KmsInvalidState":
            throw await de_KmsInvalidStateRes(parsedOutput, context);
        case "KmsNotFound":
        case "com.amazonaws.sqs#KmsNotFound":
            throw await de_KmsNotFoundRes(parsedOutput, context);
        case "KmsOptInRequired":
        case "com.amazonaws.sqs#KmsOptInRequired":
            throw await de_KmsOptInRequiredRes(parsedOutput, context);
        case "KmsThrottled":
        case "com.amazonaws.sqs#KmsThrottled":
            throw await de_KmsThrottledRes(parsedOutput, context);
        case "QueueDoesNotExist":
        case "com.amazonaws.sqs#QueueDoesNotExist":
            throw await de_QueueDoesNotExistRes(parsedOutput, context);
        case "RequestThrottled":
        case "com.amazonaws.sqs#RequestThrottled":
            throw await de_RequestThrottledRes(parsedOutput, context);
        case "UnsupportedOperation":
        case "com.amazonaws.sqs#UnsupportedOperation":
            throw await de_UnsupportedOperationRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_SendMessageBatchCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_SendMessageBatchCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = (0, smithy_client_1._json)(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
exports.de_SendMessageBatchCommand = de_SendMessageBatchCommand;
const de_SendMessageBatchCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    populateBodyWithQueryCompatibility(parsedOutput, output.headers);
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BatchEntryIdsNotDistinct":
        case "com.amazonaws.sqs#BatchEntryIdsNotDistinct":
            throw await de_BatchEntryIdsNotDistinctRes(parsedOutput, context);
        case "BatchRequestTooLong":
        case "com.amazonaws.sqs#BatchRequestTooLong":
            throw await de_BatchRequestTooLongRes(parsedOutput, context);
        case "EmptyBatchRequest":
        case "com.amazonaws.sqs#EmptyBatchRequest":
            throw await de_EmptyBatchRequestRes(parsedOutput, context);
        case "InvalidAddress":
        case "com.amazonaws.sqs#InvalidAddress":
            throw await de_InvalidAddressRes(parsedOutput, context);
        case "InvalidBatchEntryId":
        case "com.amazonaws.sqs#InvalidBatchEntryId":
            throw await de_InvalidBatchEntryIdRes(parsedOutput, context);
        case "InvalidSecurity":
        case "com.amazonaws.sqs#InvalidSecurity":
            throw await de_InvalidSecurityRes(parsedOutput, context);
        case "KmsAccessDenied":
        case "com.amazonaws.sqs#KmsAccessDenied":
            throw await de_KmsAccessDeniedRes(parsedOutput, context);
        case "KmsDisabled":
        case "com.amazonaws.sqs#KmsDisabled":
            throw await de_KmsDisabledRes(parsedOutput, context);
        case "KmsInvalidKeyUsage":
        case "com.amazonaws.sqs#KmsInvalidKeyUsage":
            throw await de_KmsInvalidKeyUsageRes(parsedOutput, context);
        case "KmsInvalidState":
        case "com.amazonaws.sqs#KmsInvalidState":
            throw await de_KmsInvalidStateRes(parsedOutput, context);
        case "KmsNotFound":
        case "com.amazonaws.sqs#KmsNotFound":
            throw await de_KmsNotFoundRes(parsedOutput, context);
        case "KmsOptInRequired":
        case "com.amazonaws.sqs#KmsOptInRequired":
            throw await de_KmsOptInRequiredRes(parsedOutput, context);
        case "KmsThrottled":
        case "com.amazonaws.sqs#KmsThrottled":
            throw await de_KmsThrottledRes(parsedOutput, context);
        case "QueueDoesNotExist":
        case "com.amazonaws.sqs#QueueDoesNotExist":
            throw await de_QueueDoesNotExistRes(parsedOutput, context);
        case "RequestThrottled":
        case "com.amazonaws.sqs#RequestThrottled":
            throw await de_RequestThrottledRes(parsedOutput, context);
        case "TooManyEntriesInBatchRequest":
        case "com.amazonaws.sqs#TooManyEntriesInBatchRequest":
            throw await de_TooManyEntriesInBatchRequestRes(parsedOutput, context);
        case "UnsupportedOperation":
        case "com.amazonaws.sqs#UnsupportedOperation":
            throw await de_UnsupportedOperationRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_SetQueueAttributesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_SetQueueAttributesCommandError(output, context);
    }
    await (0, smithy_client_1.collectBody)(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
exports.de_SetQueueAttributesCommand = de_SetQueueAttributesCommand;
const de_SetQueueAttributesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    populateBodyWithQueryCompatibility(parsedOutput, output.headers);
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidAddress":
        case "com.amazonaws.sqs#InvalidAddress":
            throw await de_InvalidAddressRes(parsedOutput, context);
        case "InvalidAttributeName":
        case "com.amazonaws.sqs#InvalidAttributeName":
            throw await de_InvalidAttributeNameRes(parsedOutput, context);
        case "InvalidAttributeValue":
        case "com.amazonaws.sqs#InvalidAttributeValue":
            throw await de_InvalidAttributeValueRes(parsedOutput, context);
        case "InvalidSecurity":
        case "com.amazonaws.sqs#InvalidSecurity":
            throw await de_InvalidSecurityRes(parsedOutput, context);
        case "OverLimit":
        case "com.amazonaws.sqs#OverLimit":
            throw await de_OverLimitRes(parsedOutput, context);
        case "QueueDoesNotExist":
        case "com.amazonaws.sqs#QueueDoesNotExist":
            throw await de_QueueDoesNotExistRes(parsedOutput, context);
        case "RequestThrottled":
        case "com.amazonaws.sqs#RequestThrottled":
            throw await de_RequestThrottledRes(parsedOutput, context);
        case "UnsupportedOperation":
        case "com.amazonaws.sqs#UnsupportedOperation":
            throw await de_UnsupportedOperationRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_StartMessageMoveTaskCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_StartMessageMoveTaskCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = (0, smithy_client_1._json)(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
exports.de_StartMessageMoveTaskCommand = de_StartMessageMoveTaskCommand;
const de_StartMessageMoveTaskCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    populateBodyWithQueryCompatibility(parsedOutput, output.headers);
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidAddress":
        case "com.amazonaws.sqs#InvalidAddress":
            throw await de_InvalidAddressRes(parsedOutput, context);
        case "InvalidSecurity":
        case "com.amazonaws.sqs#InvalidSecurity":
            throw await de_InvalidSecurityRes(parsedOutput, context);
        case "RequestThrottled":
        case "com.amazonaws.sqs#RequestThrottled":
            throw await de_RequestThrottledRes(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.sqs#ResourceNotFoundException":
            throw await de_ResourceNotFoundExceptionRes(parsedOutput, context);
        case "UnsupportedOperation":
        case "com.amazonaws.sqs#UnsupportedOperation":
            throw await de_UnsupportedOperationRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_TagQueueCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_TagQueueCommandError(output, context);
    }
    await (0, smithy_client_1.collectBody)(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
exports.de_TagQueueCommand = de_TagQueueCommand;
const de_TagQueueCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    populateBodyWithQueryCompatibility(parsedOutput, output.headers);
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidAddress":
        case "com.amazonaws.sqs#InvalidAddress":
            throw await de_InvalidAddressRes(parsedOutput, context);
        case "InvalidSecurity":
        case "com.amazonaws.sqs#InvalidSecurity":
            throw await de_InvalidSecurityRes(parsedOutput, context);
        case "QueueDoesNotExist":
        case "com.amazonaws.sqs#QueueDoesNotExist":
            throw await de_QueueDoesNotExistRes(parsedOutput, context);
        case "RequestThrottled":
        case "com.amazonaws.sqs#RequestThrottled":
            throw await de_RequestThrottledRes(parsedOutput, context);
        case "UnsupportedOperation":
        case "com.amazonaws.sqs#UnsupportedOperation":
            throw await de_UnsupportedOperationRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_UntagQueueCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_UntagQueueCommandError(output, context);
    }
    await (0, smithy_client_1.collectBody)(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
exports.de_UntagQueueCommand = de_UntagQueueCommand;
const de_UntagQueueCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    populateBodyWithQueryCompatibility(parsedOutput, output.headers);
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidAddress":
        case "com.amazonaws.sqs#InvalidAddress":
            throw await de_InvalidAddressRes(parsedOutput, context);
        case "InvalidSecurity":
        case "com.amazonaws.sqs#InvalidSecurity":
            throw await de_InvalidSecurityRes(parsedOutput, context);
        case "QueueDoesNotExist":
        case "com.amazonaws.sqs#QueueDoesNotExist":
            throw await de_QueueDoesNotExistRes(parsedOutput, context);
        case "RequestThrottled":
        case "com.amazonaws.sqs#RequestThrottled":
            throw await de_RequestThrottledRes(parsedOutput, context);
        case "UnsupportedOperation":
        case "com.amazonaws.sqs#UnsupportedOperation":
            throw await de_UnsupportedOperationRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_BatchEntryIdsNotDistinctRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = (0, smithy_client_1._json)(body);
    const exception = new models_0_1.BatchEntryIdsNotDistinct({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, body);
};
const de_BatchRequestTooLongRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = (0, smithy_client_1._json)(body);
    const exception = new models_0_1.BatchRequestTooLong({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, body);
};
const de_EmptyBatchRequestRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = (0, smithy_client_1._json)(body);
    const exception = new models_0_1.EmptyBatchRequest({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, body);
};
const de_InvalidAddressRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = (0, smithy_client_1._json)(body);
    const exception = new models_0_1.InvalidAddress({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, body);
};
const de_InvalidAttributeNameRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = (0, smithy_client_1._json)(body);
    const exception = new models_0_1.InvalidAttributeName({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, body);
};
const de_InvalidAttributeValueRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = (0, smithy_client_1._json)(body);
    const exception = new models_0_1.InvalidAttributeValue({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, body);
};
const de_InvalidBatchEntryIdRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = (0, smithy_client_1._json)(body);
    const exception = new models_0_1.InvalidBatchEntryId({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, body);
};
const de_InvalidIdFormatRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = (0, smithy_client_1._json)(body);
    const exception = new models_0_1.InvalidIdFormat({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, body);
};
const de_InvalidMessageContentsRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = (0, smithy_client_1._json)(body);
    const exception = new models_0_1.InvalidMessageContents({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, body);
};
const de_InvalidSecurityRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = (0, smithy_client_1._json)(body);
    const exception = new models_0_1.InvalidSecurity({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, body);
};
const de_KmsAccessDeniedRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = (0, smithy_client_1._json)(body);
    const exception = new models_0_1.KmsAccessDenied({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, body);
};
const de_KmsDisabledRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = (0, smithy_client_1._json)(body);
    const exception = new models_0_1.KmsDisabled({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, body);
};
const de_KmsInvalidKeyUsageRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = (0, smithy_client_1._json)(body);
    const exception = new models_0_1.KmsInvalidKeyUsage({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, body);
};
const de_KmsInvalidStateRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = (0, smithy_client_1._json)(body);
    const exception = new models_0_1.KmsInvalidState({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, body);
};
const de_KmsNotFoundRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = (0, smithy_client_1._json)(body);
    const exception = new models_0_1.KmsNotFound({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, body);
};
const de_KmsOptInRequiredRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = (0, smithy_client_1._json)(body);
    const exception = new models_0_1.KmsOptInRequired({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, body);
};
const de_KmsThrottledRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = (0, smithy_client_1._json)(body);
    const exception = new models_0_1.KmsThrottled({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, body);
};
const de_MessageNotInflightRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = (0, smithy_client_1._json)(body);
    const exception = new models_0_1.MessageNotInflight({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, body);
};
const de_OverLimitRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = (0, smithy_client_1._json)(body);
    const exception = new models_0_1.OverLimit({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, body);
};
const de_PurgeQueueInProgressRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = (0, smithy_client_1._json)(body);
    const exception = new models_0_1.PurgeQueueInProgress({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, body);
};
const de_QueueDeletedRecentlyRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = (0, smithy_client_1._json)(body);
    const exception = new models_0_1.QueueDeletedRecently({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, body);
};
const de_QueueDoesNotExistRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = (0, smithy_client_1._json)(body);
    const exception = new models_0_1.QueueDoesNotExist({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, body);
};
const de_QueueNameExistsRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = (0, smithy_client_1._json)(body);
    const exception = new models_0_1.QueueNameExists({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, body);
};
const de_ReceiptHandleIsInvalidRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = (0, smithy_client_1._json)(body);
    const exception = new models_0_1.ReceiptHandleIsInvalid({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, body);
};
const de_RequestThrottledRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = (0, smithy_client_1._json)(body);
    const exception = new models_0_1.RequestThrottled({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, body);
};
const de_ResourceNotFoundExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = (0, smithy_client_1._json)(body);
    const exception = new models_0_1.ResourceNotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, body);
};
const de_TooManyEntriesInBatchRequestRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = (0, smithy_client_1._json)(body);
    const exception = new models_0_1.TooManyEntriesInBatchRequest({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, body);
};
const de_UnsupportedOperationRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = (0, smithy_client_1._json)(body);
    const exception = new models_0_1.UnsupportedOperation({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return (0, smithy_client_1.decorateServiceException)(exception, body);
};
const se_ActionNameList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return (0, core_1._toStr)(entry);
    });
};
const se_AddPermissionRequest = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        AWSAccountIds: (_) => se_AWSAccountIdList(_, context),
        Actions: (_) => se_ActionNameList(_, context),
        Label: core_1._toStr,
        QueueUrl: core_1._toStr,
    });
};
const se_AttributeNameList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return (0, core_1._toStr)(entry);
    });
};
const se_AWSAccountIdList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return (0, core_1._toStr)(entry);
    });
};
const se_BinaryList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return context.base64Encoder(entry);
    });
};
const se_CancelMessageMoveTaskRequest = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        TaskHandle: core_1._toStr,
    });
};
const se_ChangeMessageVisibilityBatchRequest = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        Entries: (_) => se_ChangeMessageVisibilityBatchRequestEntryList(_, context),
        QueueUrl: core_1._toStr,
    });
};
const se_ChangeMessageVisibilityBatchRequestEntry = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        Id: core_1._toStr,
        ReceiptHandle: core_1._toStr,
        VisibilityTimeout: core_1._toNum,
    });
};
const se_ChangeMessageVisibilityBatchRequestEntryList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return se_ChangeMessageVisibilityBatchRequestEntry(entry, context);
    });
};
const se_ChangeMessageVisibilityRequest = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        QueueUrl: core_1._toStr,
        ReceiptHandle: core_1._toStr,
        VisibilityTimeout: core_1._toNum,
    });
};
const se_CreateQueueRequest = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        Attributes: (_) => se_QueueAttributeMap(_, context),
        QueueName: core_1._toStr,
        tags: (_) => se_TagMap(_, context),
    });
};
const se_DeleteMessageBatchRequest = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        Entries: (_) => se_DeleteMessageBatchRequestEntryList(_, context),
        QueueUrl: core_1._toStr,
    });
};
const se_DeleteMessageBatchRequestEntry = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        Id: core_1._toStr,
        ReceiptHandle: core_1._toStr,
    });
};
const se_DeleteMessageBatchRequestEntryList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return se_DeleteMessageBatchRequestEntry(entry, context);
    });
};
const se_DeleteMessageRequest = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        QueueUrl: core_1._toStr,
        ReceiptHandle: core_1._toStr,
    });
};
const se_DeleteQueueRequest = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        QueueUrl: core_1._toStr,
    });
};
const se_GetQueueAttributesRequest = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        AttributeNames: (_) => se_AttributeNameList(_, context),
        QueueUrl: core_1._toStr,
    });
};
const se_GetQueueUrlRequest = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        QueueName: core_1._toStr,
        QueueOwnerAWSAccountId: core_1._toStr,
    });
};
const se_ListDeadLetterSourceQueuesRequest = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        MaxResults: core_1._toNum,
        NextToken: core_1._toStr,
        QueueUrl: core_1._toStr,
    });
};
const se_ListMessageMoveTasksRequest = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        MaxResults: core_1._toNum,
        SourceArn: core_1._toStr,
    });
};
const se_ListQueuesRequest = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        MaxResults: core_1._toNum,
        NextToken: core_1._toStr,
        QueueNamePrefix: core_1._toStr,
    });
};
const se_ListQueueTagsRequest = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        QueueUrl: core_1._toStr,
    });
};
const se_MessageAttributeNameList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return (0, core_1._toStr)(entry);
    });
};
const se_MessageAttributeValue = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        BinaryListValues: (_) => se_BinaryList(_, context),
        BinaryValue: context.base64Encoder,
        DataType: core_1._toStr,
        StringListValues: (_) => se_StringList(_, context),
        StringValue: core_1._toStr,
    });
};
const se_MessageBodyAttributeMap = (input, context) => {
    return Object.entries(input).reduce((acc, [key, value]) => {
        if (value === null) {
            return acc;
        }
        acc[key] = se_MessageAttributeValue(value, context);
        return acc;
    }, {});
};
const se_MessageBodySystemAttributeMap = (input, context) => {
    return Object.entries(input).reduce((acc, [key, value]) => {
        if (value === null) {
            return acc;
        }
        acc[key] = se_MessageSystemAttributeValue(value, context);
        return acc;
    }, {});
};
const se_MessageSystemAttributeValue = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        BinaryListValues: (_) => se_BinaryList(_, context),
        BinaryValue: context.base64Encoder,
        DataType: core_1._toStr,
        StringListValues: (_) => se_StringList(_, context),
        StringValue: core_1._toStr,
    });
};
const se_PurgeQueueRequest = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        QueueUrl: core_1._toStr,
    });
};
const se_QueueAttributeMap = (input, context) => {
    return Object.entries(input).reduce((acc, [key, value]) => {
        if (value === null) {
            return acc;
        }
        acc[key] = (0, core_1._toStr)(value);
        return acc;
    }, {});
};
const se_ReceiveMessageRequest = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        AttributeNames: (_) => se_AttributeNameList(_, context),
        MaxNumberOfMessages: core_1._toNum,
        MessageAttributeNames: (_) => se_MessageAttributeNameList(_, context),
        QueueUrl: core_1._toStr,
        ReceiveRequestAttemptId: core_1._toStr,
        VisibilityTimeout: core_1._toNum,
        WaitTimeSeconds: core_1._toNum,
    });
};
const se_RemovePermissionRequest = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        Label: core_1._toStr,
        QueueUrl: core_1._toStr,
    });
};
const se_SendMessageBatchRequest = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        Entries: (_) => se_SendMessageBatchRequestEntryList(_, context),
        QueueUrl: core_1._toStr,
    });
};
const se_SendMessageBatchRequestEntry = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        DelaySeconds: core_1._toNum,
        Id: core_1._toStr,
        MessageAttributes: (_) => se_MessageBodyAttributeMap(_, context),
        MessageBody: core_1._toStr,
        MessageDeduplicationId: core_1._toStr,
        MessageGroupId: core_1._toStr,
        MessageSystemAttributes: (_) => se_MessageBodySystemAttributeMap(_, context),
    });
};
const se_SendMessageBatchRequestEntryList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return se_SendMessageBatchRequestEntry(entry, context);
    });
};
const se_SendMessageRequest = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        DelaySeconds: core_1._toNum,
        MessageAttributes: (_) => se_MessageBodyAttributeMap(_, context),
        MessageBody: core_1._toStr,
        MessageDeduplicationId: core_1._toStr,
        MessageGroupId: core_1._toStr,
        MessageSystemAttributes: (_) => se_MessageBodySystemAttributeMap(_, context),
        QueueUrl: core_1._toStr,
    });
};
const se_SetQueueAttributesRequest = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        Attributes: (_) => se_QueueAttributeMap(_, context),
        QueueUrl: core_1._toStr,
    });
};
const se_StartMessageMoveTaskRequest = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        DestinationArn: core_1._toStr,
        MaxNumberOfMessagesPerSecond: core_1._toNum,
        SourceArn: core_1._toStr,
    });
};
const se_StringList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return (0, core_1._toStr)(entry);
    });
};
const se_TagKeyList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return (0, core_1._toStr)(entry);
    });
};
const se_TagMap = (input, context) => {
    return Object.entries(input).reduce((acc, [key, value]) => {
        if (value === null) {
            return acc;
        }
        acc[key] = (0, core_1._toStr)(value);
        return acc;
    }, {});
};
const se_TagQueueRequest = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        QueueUrl: core_1._toStr,
        Tags: (_) => se_TagMap(_, context),
    });
};
const se_UntagQueueRequest = (input, context) => {
    return (0, smithy_client_1.take)(input, {
        QueueUrl: core_1._toStr,
        TagKeys: (_) => se_TagKeyList(_, context),
    });
};
const de_BinaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return context.base64Decoder(entry);
    });
    return retVal;
};
const de_Message = (output, context) => {
    return (0, smithy_client_1.take)(output, {
        Attributes: smithy_client_1._json,
        Body: smithy_client_1.expectString,
        MD5OfBody: smithy_client_1.expectString,
        MD5OfMessageAttributes: smithy_client_1.expectString,
        MessageAttributes: (_) => de_MessageBodyAttributeMap(_, context),
        MessageId: smithy_client_1.expectString,
        ReceiptHandle: smithy_client_1.expectString,
    });
};
const de_MessageAttributeValue = (output, context) => {
    return (0, smithy_client_1.take)(output, {
        BinaryListValues: (_) => de_BinaryList(_, context),
        BinaryValue: context.base64Decoder,
        DataType: smithy_client_1.expectString,
        StringListValues: smithy_client_1._json,
        StringValue: smithy_client_1.expectString,
    });
};
const de_MessageBodyAttributeMap = (output, context) => {
    return Object.entries(output).reduce((acc, [key, value]) => {
        if (value === null) {
            return acc;
        }
        acc[key] = de_MessageAttributeValue(value, context);
        return acc;
    }, {});
};
const de_MessageList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_Message(entry, context);
    });
    return retVal;
};
const de_ReceiveMessageResult = (output, context) => {
    return (0, smithy_client_1.take)(output, {
        Messages: (_) => de_MessageList(_, context),
    });
};
const deserializeMetadata = (output) => ({
    httpStatusCode: output.statusCode,
    requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
    extendedRequestId: output.headers["x-amz-id-2"],
    cfId: output.headers["x-amz-cf-id"],
});
const collectBodyString = (streamBody, context) => (0, smithy_client_1.collectBody)(streamBody, context).then((body) => context.utf8Encoder(body));
const throwDefaultError = (0, smithy_client_1.withBaseException)(SQSServiceException_1.SQSServiceException);
const buildHttpRpcRequest = async (context, headers, path, resolvedHostname, body) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const contents = {
        protocol,
        hostname,
        port,
        method: "POST",
        path: basePath.endsWith("/") ? basePath.slice(0, -1) + path : basePath + path,
        headers,
    };
    if (resolvedHostname !== undefined) {
        contents.hostname = resolvedHostname;
    }
    if (body !== undefined) {
        contents.body = body;
    }
    return new protocol_http_1.HttpRequest(contents);
};
function sharedHeaders(operation) {
    return {
        "content-type": "application/x-amz-json-1.0",
        "x-amz-target": `AmazonSQS.${operation}`,
    };
}
const parseBody = (streamBody, context) => collectBodyString(streamBody, context).then((encoded) => {
    if (encoded.length) {
        return JSON.parse(encoded);
    }
    return {};
});
const parseErrorBody = async (errorBody, context) => {
    const value = await parseBody(errorBody, context);
    value.message = value.message ?? value.Message;
    return value;
};
const loadRestJsonErrorCode = (output, data) => {
    const findKey = (object, key) => Object.keys(object).find((k) => k.toLowerCase() === key.toLowerCase());
    const sanitizeErrorCode = (rawValue) => {
        let cleanValue = rawValue;
        if (typeof cleanValue === "number") {
            cleanValue = cleanValue.toString();
        }
        if (cleanValue.indexOf(",") >= 0) {
            cleanValue = cleanValue.split(",")[0];
        }
        if (cleanValue.indexOf(":") >= 0) {
            cleanValue = cleanValue.split(":")[0];
        }
        if (cleanValue.indexOf("#") >= 0) {
            cleanValue = cleanValue.split("#")[1];
        }
        return cleanValue;
    };
    const headerKey = findKey(output.headers, "x-amzn-errortype");
    if (headerKey !== undefined) {
        return sanitizeErrorCode(output.headers[headerKey]);
    }
    if (data.code !== undefined) {
        return sanitizeErrorCode(data.code);
    }
    if (data["__type"] !== undefined) {
        return sanitizeErrorCode(data["__type"]);
    }
};
const populateBodyWithQueryCompatibility = (parsedOutput, headers) => {
    const queryErrorHeader = headers["x-amzn-query-error"];
    if (parsedOutput.body !== undefined && queryErrorHeader != null) {
        const codeAndType = queryErrorHeader.split(";");
        parsedOutput.body.Code = codeAndType[0];
        parsedOutput.body.Type = codeAndType[1];
    }
};
