import { HttpMethods, PlainObject, StringOrNumber, RemoveType, NarrowPlainObject } from '@gilbarbara/types';

interface CorsOptions {
    /** @default true */
    allowCredentials?: boolean;
    /** @default [] */
    allowedHeaders?: string[];
    /** @default ['GET'] */
    methods?: HttpMethods[];
    /** @default * */
    origin?: string;
    responseHeaders?: PlainObject<string>;
    /** @default 200 */
    statusCode?: number;
}
interface FormatDateLocaleOptions {
    locale?: string;
    showTime?: boolean;
}
interface FormatMoneyOptions {
    decimalChar?: ',' | '.';
    showCents?: boolean;
    symbol?: string;
    thousandsChar?: ',' | '.';
}
type InvertKeyValue<T extends Record<PropertyKey, PropertyKey>> = {
    [K in T[keyof T]]: {
        [P in keyof T]: T[P] extends K ? P : never;
    }[keyof T];
};
interface LoggerOptions {
    collapsed?: boolean;
    hideTimestamp?: boolean;
    skip?: boolean;
    typeColor?: string;
}
interface PollOptions {
    delay?: number;
    maxRetries?: number;
}
interface QueryStringFormatOptions {
    addPrefix?: boolean;
    encodeValuesOnly?: boolean;
    encoder?: (uri: string) => string;
}
interface RequestOptions {
    body?: any;
    headers?: PlainObject<string>;
    method?: HttpMethods;
}
interface RequestError extends Error {
    response: any;
    status: number;
}
interface SortFunction {
    <T extends PlainObject = PlainObject>(left: PlainObject<T>, right: PlainObject<T>): number;
    <T = string>(left: T, right: T): number;
}
interface TimeSinceOptions {
    /**
     * @default "day"
     */
    day?: string;
    /**
     * @default "days"
     */
    days?: string;
    /**
     * @default "hour"
     */
    hour?: string;
    /**
     * @default "hours"
     */
    hours?: string;
    /**
     * @default "minute"
     */
    minute?: string;
    /**
     * @default "minutes"
     */
    minutes?: string;
    /**
     * @default "month"
     */
    month?: string;
    /**
     * @default "months"
     */
    months?: string;
    prefix?: string;
    /**
     * @default "second"
     */
    second?: string;
    /**
     * @default "seconds"
     */
    seconds?: string;
    /**
     * @default false
     */
    skipWeeks?: boolean;
    /**
     * @default "ago"
     */
    suffix?: string;
    /**
     * @default "week"
     */
    week?: string;
    /**
     * @default "weeks"
     */
    weeks?: string;
    /**
     * @default "year"
     */
    year?: string;
    /**
     * @default "years"
     */
    years?: string;
}
interface UniqueOptions {
    includeLowercase?: boolean;
    includeNumbers?: boolean;
    includeSymbols?: boolean;
    includeUppercase?: boolean;
}
interface ValidatePasswordOptions {
    maxLength?: number;
    maxLengthMessage?: string;
    minLength?: number;
    minLengthMessage?: string;
    regex?: RegExp;
    requiredCharactersMessage?: string;
}

type types_CorsOptions = CorsOptions;
type types_FormatDateLocaleOptions = FormatDateLocaleOptions;
type types_FormatMoneyOptions = FormatMoneyOptions;
type types_InvertKeyValue<T extends Record<PropertyKey, PropertyKey>> = InvertKeyValue<T>;
type types_LoggerOptions = LoggerOptions;
type types_PollOptions = PollOptions;
type types_QueryStringFormatOptions = QueryStringFormatOptions;
type types_RequestError = RequestError;
type types_RequestOptions = RequestOptions;
type types_SortFunction = SortFunction;
type types_TimeSinceOptions = TimeSinceOptions;
type types_UniqueOptions = UniqueOptions;
type types_ValidatePasswordOptions = ValidatePasswordOptions;
declare namespace types {
  export {
    types_CorsOptions as CorsOptions,
    types_FormatDateLocaleOptions as FormatDateLocaleOptions,
    types_FormatMoneyOptions as FormatMoneyOptions,
    types_InvertKeyValue as InvertKeyValue,
    types_LoggerOptions as LoggerOptions,
    types_PollOptions as PollOptions,
    types_QueryStringFormatOptions as QueryStringFormatOptions,
    types_RequestError as RequestError,
    types_RequestOptions as RequestOptions,
    types_SortFunction as SortFunction,
    types_TimeSinceOptions as TimeSinceOptions,
    types_UniqueOptions as UniqueOptions,
    types_ValidatePasswordOptions as ValidatePasswordOptions,
  };
}

/**
 * Create a sequential array of numbers
 */
declare function createArray(size: number, start?: number): number[];
/**
 * Get a random item from an array
 */
declare function getRandomItem<T>(input: T[]): T;
/**
 * Sort an array of numbers using a quick sort algorithm
 */
declare function quickSort<T extends string | number>(input: T[], comparator?: typeof sortComparator): T[];
/**
 * Remove duplicates from the array
 */
declare function removeDuplicates<T = unknown>(input: T[]): T[];
/**
 * Shuffle an array using the Fisher-Yates algorithm
 */
declare function shuffle<T = unknown>(input: T[]): T[];
/**
 * Sort an array with localeCompare
 */
declare function sortByLocaleCompare(key?: string, options?: Intl.CollatorOptions & {
    descending?: boolean;
}): SortFunction;
/**
 * Sort an array by primitive values
 */
declare function sortByPrimitive<T extends number | boolean>(key?: string, descending?: boolean): SortFunction;
/**
 * Basic sort comparator
 */
declare function sortComparator(left: string | number, right: string | number): 1 | 0 | -1;
declare function splitIntoChunks<T>(input: T[], chunkSize?: number): T[][];

declare const ASYNC_STATUS: {
    readonly IDLE: "IDLE";
    readonly PENDING: "PENDING";
    readonly SUCCESS: "SUCCESS";
    readonly ERROR: "ERROR";
};
/**
 * Format a CORS response
 */
declare function cors(data: any, statusCodeOrOptions?: number | CorsOptions): {
    body: string;
    headers: {
        'Access-Control-Expose-Headers'?: string | undefined;
        'Access-Control-Allow-Origin': string;
        'Access-Control-Allow-Credentials': boolean;
        'Access-Control-Allow-Methods': string;
        'Access-Control-Allow-Headers': string;
    };
    statusCode: number;
};
/**
 *
 * @param condition
 * @param options
 */
declare function poll(condition: () => boolean, options?: PollOptions): Promise<void>;
/**
 * Make async requests
 */
declare function request<D = any>(url: string, options?: RequestOptions): Promise<D>;
/**
 * Block execution
 */
declare function sleep(seconds?: number): Promise<unknown>;

declare const MINUTE = 60;
declare const HOUR: number;
declare const DAY: number;
declare const WEEK: number;
declare const MONTH: number;
declare const YEAR: number;
declare function isIsoDate(input: string): boolean;
/**
 * Check if the input is a valid date.
 */
declare function isoDate(input?: string | number): string;
/**
 * Check if the input is a valid date.
 */
declare function isValidDate(input: string | number | Date): boolean;
/**
 * Returns the unixtime (in seconds).
 */
declare function now(): number;
/**
 * Returns how much time has passed since the input.
 */
declare function timeSince(input: Date | string | number, options?: TimeSinceOptions): string;
/**
 * Get the timestamp (in seconds) for a date.
 */
declare function timestamp(input?: Date | string): number;

/**
 * Detect if the device is in dark mode
 */
declare function isDarkMode(): boolean;
/**
 * Detect if the device supports touch events
 */
declare function isTouchDevice(): boolean;
/**
 * Detect if the user prefers reduced motion
 */
declare function prefersReducedMotion(): boolean;

/**
 * Format boolean into a Yes/No string
 */
declare function formatBoolean(input: boolean): "Yes" | "No";
/**
 * Format string into a CPF
 */
declare function formatCPF(value: string): string;
/**
 * Format date ISO string using locale
 */
declare function formatDateLocale(input: string, options?: FormatDateLocaleOptions): string;
/**
 * Format number into money string
 */
declare function formatMoney(input: number, options?: FormatMoneyOptions): string;
/**
 * Format string into a brazilian phone
 */
declare function formatPhoneBR(input: string): string;
/**
 * Format string into a US phone
 */
declare function formatPhoneUS(input: string): string;
/**
 * Format string into a zip code
 */
declare function formatPostalCodeBR(value: string): string;

/**
 * Decouple methods from objects
 */
declare function demethodize(fn: Function): (parameter: any, ...rest: any[]) => any;
/**
 * Measure function execution time
 */
declare function measureExecutionTime<T = any>(callback: Function): Promise<T>;
/**
 * A function that does nothing.
 */
declare function noop(): undefined;
/**
 * Creates a function that will only be called once.
 * Repeat calls return the value of the first invocation.
 */
declare function once<T extends (...arguments_: Array<any>) => any>(fn: T): T;
/**
 * Combine multiple functions into one.
 * The output of each function is passed as the input to the next.
 */
declare function pipe<T>(...fns: Array<(argument: T) => T>): (input: T) => T;

type Case<T = void> = [boolean, () => T];
declare function conditional<TReturn = void>(cases: Array<Case<TReturn>>, defaultCase?: () => TReturn): TReturn | undefined;
/**
 * Copy a string to the clipboard
 */
declare function copyToClipboard(input: string): Promise<boolean>;
/**
 * Get the data type of variable.
 */
declare function getDataType(input: unknown, toLowerCase?: boolean): string;
declare function invariant(condition: any, message: string | (() => string)): asserts condition;
/**
 * Check if a string is a valid JSON
 */
declare function isJSON(input: string): boolean;
/**
 * Throw an error if the parameter isn't provided
 */
declare function isRequired(input?: string, Constructable?: TypeErrorConstructor): void;
/**
 * Log grouped messages to the console
 */
declare function logger(type: string, title: string, data: any, options?: LoggerOptions): void;
/**
 * Returns the value or null
 */
declare function nullify<T>(value: T): NonNullable<T> | null;
declare function popupCenter(url: string, title: string, width: number, height: number): Window | null;
declare function px(value: undefined): undefined;
declare function px(value: StringOrNumber): string;
declare function px(value: StringOrNumber | undefined): string | undefined;
/**
 * Return a unique string
 */
declare function unique(length?: number, options?: UniqueOptions): string;
/**
 * Returns an UUID v4 string.
 */
declare function uuid(): string;

/**
 * Ceil decimal numbers
 */
declare function ceil(input: number, digits?: number): number;
/**
 * Limit number between range
 */
declare function clamp(value: number, min?: number, max?: number): number;
/**
 * Floor decimal numbers
 */
declare function floor(input: number, digits?: number): number;
/**
 * Pad a number with zeros
 */
declare function pad(input: number, length?: number): string;
/**
 * Returns a random number
 */
declare function randomNumber(min?: number, max?: number): number;
/**
 * Round decimal numbers
 */
declare function round(input: number, digits?: number): number;

/**
 * Remove properties with undefined value from an object
 */
declare function cleanUpObject<T extends PlainObject>(input: T): RemoveType<T, undefined>;
/**
 * Get a nested property inside an object or array
 */
declare function getNestedProperty<T extends PlainObject<any>>(input: T, path: string): any;
/**
 * Invert object key and value
 */
declare function invertKeys<const T extends PlainObject<PropertyKey>>(input: T): InvertKeyValue<T>;
/**
 * Set the key as the value
 */
declare function keyMirror<T extends PlainObject>(input: T): {
    [K in keyof T]: K;
};
/**
 * Merges the defaultProps with literal values with the incoming props, removing undefined values from it that would override the defaultProps.
 * The result is a type-safe object with the defaultProps as required properties.
 */
declare function mergeProps<TDefaultProps extends PlainObject<any>, TProps extends PlainObject<any>>(defaultProps: TDefaultProps, props: TProps): TProps & Required<Pick<TProps, keyof TDefaultProps & string>> extends infer T ? { [KeyType_1 in keyof T]: (TProps & Required<Pick<TProps, keyof TDefaultProps & string>>)[KeyType_1]; } : never;
/**
 * Type-safe Object.entries()
 */
declare function objectEntries<T extends PlainObject<any>>(input: T): { [K in keyof T]-?: [K, T[K]]; }[keyof T][];
/**
 * Type-safe Object.keys()
 */
declare function objectKeys<T extends PlainObject<any>>(input: T): (keyof T)[];
/**
 * Convert an object to an array of objects
 */
declare function objectToArray<T extends PlainObject>(input: T, includeOnly?: string): {
    [x: string]: unknown;
}[];
/**
 * Remove properties from an object
 */
declare function omit<T extends Record<string, any>, K extends keyof T>(input: NarrowPlainObject<T>, ...filter: K[]): Omit<T, K>;
/**
 * Select properties from an object
 */
declare function pick<T extends Record<string, any>, K extends keyof T>(input: NarrowPlainObject<T>, ...filter: K[]): Pick<T, K>;
/**
 * Stringify a shallow object into a query string
 */
declare function queryStringFormat<T extends PlainObject>(input: T, options?: QueryStringFormatOptions): string;
/**
 * Parse a query string
 */
declare function queryStringParse(input: string): PlainObject<string>;
/**
 * Sort object keys
 */
declare function sortObjectKeys<T extends PlainObject>(input: T): T;

/**
 * Returns the average of two or more numbers
 */
declare function mean(input: number[], precision?: number): number;
/**
 * Returns the median of two or more numbers
 */
declare function median(input: number[]): number;
/**
 * Returns the mode of two or more numbers
 */
declare function mode(input: number[]): number;

/**
 * Capitalize the first letter
 */
declare function capitalize(input: string): string;
/**
 * Cleanup HTML content
 */
declare function cleanupHTML(input: string): string;
/**
 * Cleanup a numeric string
 */
declare function cleanupNumericString(value?: string): string;
/**
 * Cleanup URI characters
 */
declare function cleanupURI(input: string): string;
/**
 * Get initials from name
 */
declare function getInitials(input: string): string;
/**
 * Pluralize strings.
 *
 * If the plural form just adds an `s` to the end, you don't need to pass it.
 */
declare function pluralize(quantity: number, singular: string, plural?: string): string;
/**
 * Remove accents
 */
declare function removeAccents(input: string): string;
/**
 * Remove emojis
 */
declare function removeEmojis(input: string): string;
/**
 * Remove empty HTML Tags (including whitespace)
 */
declare function removeEmptyTags(input: string): string;
/**
 * Remove non-printable ASCII characters
 */
declare function removeNonPrintableCharacters(input: string): string;
/**
 * Remove HTML tags
 */
declare function removeTags(input: string): string;
/**
 * Remove whitespace
 */
declare function removeWhitespace(input: string): string;
/**
 * Format string to slug
 */
declare function slugify(input: string): string;

/**
 * Check if CPF is valid
 */

declare function isValidCPF(value: string): boolean;
/**
 * Check if email is valid
 */
declare function isValidEmail(value: string): boolean;
/**
 * Validate password length and required characters
 * @throws
 */
declare function validatePassword(password: string, options?: ValidatePasswordOptions): boolean;

export { ASYNC_STATUS, DAY, HOUR, MINUTE, MONTH, types as Types, WEEK, YEAR, capitalize, ceil, clamp, cleanUpObject, cleanupHTML, cleanupNumericString, cleanupURI, conditional, copyToClipboard, cors, createArray, demethodize, floor, formatBoolean, formatCPF, formatDateLocale, formatMoney, formatPhoneBR, formatPhoneUS, formatPostalCodeBR, getDataType, getInitials, getNestedProperty, getRandomItem, invariant, invertKeys, isDarkMode, isIsoDate, isJSON, isRequired, isTouchDevice, isValidCPF, isValidDate, isValidEmail, isoDate, keyMirror, logger, mean, measureExecutionTime, median, mergeProps, mode, noop, now, nullify, objectEntries, objectKeys, objectToArray, omit, once, pad, pick, pipe, pluralize, poll, popupCenter, prefersReducedMotion, px, queryStringFormat, queryStringParse, quickSort, randomNumber, removeAccents, removeDuplicates, removeEmojis, removeEmptyTags, removeNonPrintableCharacters, removeTags, removeWhitespace, request, round, shuffle, sleep, slugify, sortByLocaleCompare, sortByPrimitive, sortComparator, sortObjectKeys, splitIntoChunks, timeSince, timestamp, unique, uuid, validatePassword };
