import { promises, unlink as fsUnlink } from 'fs';
const { writeFile: fsWriteFile, readFile: fsReadFile, mkdir } = promises;
export function writeFile(filepath, content) {
    return fsWriteFile(filepath, content);
}
export function readFile(filepath) {
    return fsReadFile(filepath, 'utf-8');
}
export function unlinkFile(filePath, cb) {
    fsUnlink(filePath, cb);
}
export function mkdirp(filePath) {
    return mkdir(filePath, { recursive: true });
}
