import { GraphQLSchema } from 'graphql';
import { ExecutionRequest, ExecutionResult } from '@graphql-tools/utils';
import { Transform, DelegationContext, SubschemaConfig } from '@graphql-tools/delegate';
interface WrapFieldsTransformationContext {
    nextIndex: number;
    paths: Record<string, {
        pathToField: Array<string>;
        alias: string;
    }>;
}
export default class WrapFields<TContext extends Record<string, any>> implements Transform<WrapFieldsTransformationContext, TContext> {
    private readonly outerTypeName;
    private readonly wrappingFieldNames;
    private readonly wrappingTypeNames;
    private readonly numWraps;
    private readonly fieldNames;
    private readonly transformer;
    constructor(outerTypeName: string, wrappingFieldNames: Array<string>, wrappingTypeNames: Array<string>, fieldNames?: Array<string>, prefix?: string);
    transformSchema(originalWrappingSchema: GraphQLSchema, subschemaConfig: SubschemaConfig<any, any, any, TContext>): GraphQLSchema;
    transformRequest(originalRequest: ExecutionRequest, delegationContext: DelegationContext<TContext>, transformationContext: WrapFieldsTransformationContext): ExecutionRequest;
    transformResult(originalResult: ExecutionResult, delegationContext: DelegationContext<TContext>, transformationContext: WrapFieldsTransformationContext): ExecutionResult;
}
export declare function dehoistValue(originalValue: any, context: WrapFieldsTransformationContext): any;
export {};
