import { ProtoSignDocDecoder } from "../decoder";
import { Coin, StdSignDoc } from "@cosmjs/launchpad";
import { SignDoc } from "@keplr-wallet/proto-types/cosmos/tx/v1beta1/tx";
export declare class SignDocWrapper {
    protected readonly signDoc: StdSignDoc | SignDoc;
    protected _protoSignDoc?: ProtoSignDocDecoder;
    readonly isADR36SignDoc: boolean;
    readonly mode: "amino" | "direct";
    constructor(signDoc: StdSignDoc | SignDoc);
    static fromAminoSignDoc(signDoc: StdSignDoc): SignDocWrapper;
    static fromDirectSignDoc(signDoc: SignDoc): SignDocWrapper;
    static fromDirectSignDocBytes(signDocBytes: Uint8Array): SignDocWrapper;
    clone(): SignDocWrapper;
    get protoSignDoc(): ProtoSignDocDecoder;
    get aminoSignDoc(): StdSignDoc;
    get chainId(): string;
    get memo(): string;
    get fees(): readonly Coin[];
    get gas(): number;
}
