"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Hash = void 0;
const sha_js_1 = require("sha.js");
class Hash {
    static sha256(data) {
        return new Uint8Array(new sha_js_1.sha256().update(data).digest());
    }
    static truncHashPortion(str, firstCharCount = str.length, endCharCount = 0) {
        return (str.substring(0, firstCharCount) +
            "…" +
            str.substring(str.length - endCharCount, str.length));
    }
}
exports.Hash = Hash;
//# sourceMappingURL=hash.js.map