export declare type RNG = <T extends Int8Array | Int16Array | Int32Array | Uint8Array | Uint16Array | Uint32Array | Uint8ClampedArray | Float32Array | Float64Array | DataView | null>(array: T) => Promise<T>;
export declare class Mnemonic {
    static generateWallet(rng: RNG, path?: string, password?: string, strength?: number): Promise<{
        privKey: Uint8Array;
        mnemonic: string;
    }>;
    static validateMnemonic(mnemonic: string): boolean;
    static generateSeed(rng: RNG, strength?: number): Promise<string>;
    static generateWalletFromMnemonic(mnemonic: string, path?: string, password?: string): Uint8Array;
    static generateMasterSeedFromMnemonic(mnemonic: string, password?: string): Uint8Array;
    static generatePrivateKeyFromMasterSeed(seed: Uint8Array, path?: string): Uint8Array;
}
