"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Mnemonic = void 0;
// eslint-disable-next-line @typescript-eslint/no-var-requires
const bip39 = require("bip39");
// eslint-disable-next-line @typescript-eslint/no-var-requires
const bip32 = require("bip32");
// eslint-disable-next-line @typescript-eslint/no-var-requires
const bs58check = require("bs58check");
const buffer_1 = require("buffer/");
class Mnemonic {
    static generateWallet(rng, path = `m/44'/118'/0'/0/0`, password = "", strength = 256) {
        return __awaiter(this, void 0, void 0, function* () {
            const mnemonic = yield Mnemonic.generateSeed(rng, strength);
            const privKey = Mnemonic.generateWalletFromMnemonic(mnemonic, path, password);
            return {
                privKey,
                mnemonic,
            };
        });
    }
    static validateMnemonic(mnemonic) {
        return bip39.validateMnemonic(mnemonic);
    }
    static generateSeed(rng, strength = 128) {
        return __awaiter(this, void 0, void 0, function* () {
            if (strength % 32 !== 0) {
                throw new TypeError("invalid entropy");
            }
            let bytes = new Uint8Array(strength / 8);
            bytes = yield rng(bytes);
            return bip39.entropyToMnemonic(buffer_1.Buffer.from(bytes).toString("hex"));
        });
    }
    static generateWalletFromMnemonic(mnemonic, path = `m/44'/118'/0'/0/0`, password = "") {
        const seed = bip39.mnemonicToSeedSync(mnemonic, password);
        const masterSeed = bip32.fromSeed(seed);
        const hd = masterSeed.derivePath(path);
        const privateKey = hd.privateKey;
        if (!privateKey) {
            throw new Error("null hd key");
        }
        return privateKey;
    }
    static generateMasterSeedFromMnemonic(mnemonic, password = "") {
        const seed = bip39.mnemonicToSeedSync(mnemonic, password);
        const masterKey = bip32.fromSeed(seed);
        return buffer_1.Buffer.from(bs58check.decode(masterKey.toBase58()));
    }
    static generatePrivateKeyFromMasterSeed(seed, path = `m/44'/118'/0'/0/0`) {
        const masterSeed = bip32.fromBase58(bs58check.encode(seed));
        const hd = masterSeed.derivePath(path);
        const privateKey = hd.privateKey;
        if (!privateKey) {
            throw new Error("null hd key");
        }
        return privateKey;
    }
}
exports.Mnemonic = Mnemonic;
//# sourceMappingURL=mnemonic.js.map