import bigInteger from "big-integer";
import { Dec } from "./decimal";
export declare class Int {
    protected static maxInt: bigInteger.BigInteger;
    protected int: bigInteger.BigInteger;
    /**
     * @param int - Parse a number | bigInteger | string into a bigInt.
     */
    constructor(int: bigInteger.BigNumber);
    protected checkBitLen(): void;
    toString(): string;
    isNegative(): boolean;
    isPositive(): boolean;
    isZero(): boolean;
    equals(i: Int): boolean;
    gt(i: Int): boolean;
    gte(i: Int): boolean;
    lt(i: Int): boolean;
    lte(i: Int): boolean;
    abs(): Int;
    absUInt(): Uint;
    add(i: Int): Int;
    sub(i: Int): Int;
    mul(i: Int): Int;
    div(i: Int): Int;
    mod(i: Int): Int;
    neg(): Int;
    pow(i: Uint): Int;
    toDec(): Dec;
    toBigNumber(): bigInteger.BigInteger;
}
export declare class Uint {
    protected uint: bigInteger.BigInteger;
    /**
     * @param uint - Parse a number | bigInteger | string into a bigUint.
     */
    constructor(uint: bigInteger.BigNumber);
    protected checkBitLen(): void;
    toString(): string;
    isZero(): boolean;
    equals(i: Uint): boolean;
    gt(i: Uint): boolean;
    gte(i: Uint): boolean;
    lt(i: Uint): boolean;
    lte(i: Uint): boolean;
    add(i: Uint): Uint;
    sub(i: Uint): Uint;
    mul(i: Uint): Uint;
    div(i: Uint): Uint;
    mod(i: Uint): Uint;
    pow(i: Uint): Uint;
    toDec(): Dec;
    toBigNumber(): bigInteger.BigInteger;
}
