import { IntPretty, IntPrettyOptions } from "./int-pretty";
import { Dec } from "./decimal";
import { FiatCurrency } from "@keplr-wallet/types";
import { DeepReadonly } from "utility-types";
import bigInteger from "big-integer";
export declare type PricePrettyOptions = {
    separator: string;
    upperCase: boolean;
    lowerCase: boolean;
    locale: string;
};
export declare class PricePretty {
    protected _fiatCurrency: FiatCurrency;
    protected amount: Dec | {
        toDec(): Dec;
    } | bigInteger.BigNumber;
    protected intPretty: IntPretty;
    protected _options: PricePrettyOptions;
    constructor(_fiatCurrency: FiatCurrency, amount: Dec | {
        toDec(): Dec;
    } | bigInteger.BigNumber);
    get options(): DeepReadonly<Omit<IntPrettyOptions, "locale"> & PricePrettyOptions>;
    get symbol(): string;
    get fiatCurrency(): FiatCurrency;
    separator(str: string): PricePretty;
    upperCase(bool: boolean): PricePretty;
    lowerCase(bool: boolean): PricePretty;
    moveDecimalPointLeft(delta: number): PricePretty;
    moveDecimalPointRight(delta: number): PricePretty;
    /**
     * @deprecated Use`moveDecimalPointLeft`
     */
    increasePrecision(delta: number): PricePretty;
    /**
     * @deprecated Use`moveDecimalPointRight`
     */
    decreasePrecision(delta: number): PricePretty;
    maxDecimals(max: number): PricePretty;
    inequalitySymbol(bool: boolean): PricePretty;
    inequalitySymbolSeparator(str: string): PricePretty;
    trim(bool: boolean): PricePretty;
    shrink(bool: boolean): PricePretty;
    locale(locale: string): PricePretty;
    /**
     * Ready indicates the actual value is ready to show the users.
     * Even if the ready option is false, it expects that the value can be shown to users (probably as 0).
     * The method that returns prettied value may return `undefined` or `null` if the value is not ready.
     * But, alternatively, it can return the 0 value that can be shown the users anyway, but indicates that the value is not ready.
     * @param bool
     */
    ready(bool: boolean): PricePretty;
    get isReady(): boolean;
    add(target: Dec | {
        toDec(): Dec;
    }): PricePretty;
    sub(target: Dec | {
        toDec(): Dec;
    }): PricePretty;
    mul(target: Dec | {
        toDec(): Dec;
    }): PricePretty;
    quo(target: Dec | {
        toDec(): Dec;
    }): PricePretty;
    toDec(): Dec;
    toString(): string;
    clone(): PricePretty;
}
