import { Tree, NodeType, NodePropSource, TreeFragment, NodeSet, Input, Parser, PartialParse, ParseWrapper } from "@lezer/common";
export declare enum Type {
    Document = 1,
    CodeBlock = 2,
    FencedCode = 3,
    Blockquote = 4,
    HorizontalRule = 5,
    BulletList = 6,
    OrderedList = 7,
    ListItem = 8,
    ATXHeading1 = 9,
    ATXHeading2 = 10,
    ATXHeading3 = 11,
    ATXHeading4 = 12,
    ATXHeading5 = 13,
    ATXHeading6 = 14,
    SetextHeading1 = 15,
    SetextHeading2 = 16,
    HTMLBlock = 17,
    LinkReference = 18,
    Paragraph = 19,
    CommentBlock = 20,
    ProcessingInstructionBlock = 21,
    Escape = 22,
    Entity = 23,
    HardBreak = 24,
    Emphasis = 25,
    StrongEmphasis = 26,
    Link = 27,
    Image = 28,
    InlineCode = 29,
    HTMLTag = 30,
    Comment = 31,
    ProcessingInstruction = 32,
    URL = 33,
    HeaderMark = 34,
    QuoteMark = 35,
    ListMark = 36,
    LinkMark = 37,
    EmphasisMark = 38,
    CodeMark = 39,
    CodeText = 40,
    CodeInfo = 41,
    LinkTitle = 42,
    LinkLabel = 43
}
export declare class LeafBlock {
    readonly start: number;
    content: string;
    parsers: LeafBlockParser[];
}
export declare class Line {
    text: string;
    baseIndent: number;
    basePos: number;
    pos: number;
    indent: number;
    next: number;
    skipSpace(from: number): number;
    moveBase(to: number): void;
    moveBaseColumn(indent: number): void;
    addMarker(elt: Element): void;
    countIndent(to: number, from?: number, indent?: number): number;
    findColumn(goal: number): number;
}
export declare function space(ch: number): boolean;
declare type BlockResult = boolean | null;
export declare class BlockContext implements PartialParse {
    readonly parser: MarkdownParser;
    private line;
    private atEnd;
    private fragments;
    private to;
    stoppedAt: number | null;
    lineStart: number;
    get parsedPos(): number;
    advance(): Tree;
    stopAt(pos: number): void;
    private reuseFragment;
    get depth(): number;
    parentType(depth?: number): NodeType;
    nextLine(): boolean;
    private moveRangeI;
    private lineChunkAt;
    prevLineEnd(): number;
    startComposite(type: string, start: number, value?: number): void;
    addElement(elt: Element): void;
    addLeafElement(leaf: LeafBlock, elt: Element): void;
    private finish;
    private addGaps;
    elt(type: string, from: number, to: number, children?: readonly Element[]): Element;
    elt(tree: Tree, at: number): Element;
}
export interface NodeSpec {
    name: string;
    block?: boolean;
    composite?(cx: BlockContext, line: Line, value: number): boolean;
}
export interface InlineParser {
    name: string;
    parse(cx: InlineContext, next: number, pos: number): number;
    before?: string;
    after?: string;
}
export interface BlockParser {
    name: string;
    parse?(cx: BlockContext, line: Line): BlockResult;
    leaf?(cx: BlockContext, leaf: LeafBlock): LeafBlockParser | null;
    endLeaf?(cx: BlockContext, line: Line, leaf: LeafBlock): boolean;
    before?: string;
    after?: string;
}
export interface LeafBlockParser {
    nextLine(cx: BlockContext, line: Line, leaf: LeafBlock): boolean;
    finish(cx: BlockContext, leaf: LeafBlock): boolean;
}
export interface MarkdownConfig {
    props?: readonly NodePropSource[];
    defineNodes?: readonly (string | NodeSpec)[];
    parseBlock?: readonly BlockParser[];
    parseInline?: readonly InlineParser[];
    remove?: readonly string[];
    wrap?: ParseWrapper;
}
export declare type MarkdownExtension = MarkdownConfig | readonly MarkdownExtension[];
export declare class MarkdownParser extends Parser {
    readonly nodeSet: NodeSet;
    createParse(input: Input, fragments: readonly TreeFragment[], ranges: readonly {
        from: number;
        to: number;
    }[]): PartialParse;
    configure(spec: MarkdownExtension): MarkdownParser;
    parseInline(text: string, offset: number): any[];
}
export declare class Element {
    readonly type: number;
    readonly from: number;
    readonly to: number;
}
export interface DelimiterType {
    resolve?: string;
    mark?: string;
}
export declare class InlineContext {
    readonly parser: MarkdownParser;
    readonly text: string;
    readonly offset: number;
    char(pos: number): number;
    get end(): number;
    slice(from: number, to: number): string;
    addDelimiter(type: DelimiterType, from: number, to: number, open: boolean, close: boolean): number;
    addElement(elt: Element): number;
    findOpeningDelimiter(type: DelimiterType): number;
    takeContent(startIndex: number): any[];
    skipSpace(from: number): number;
    elt(type: string, from: number, to: number, children?: readonly Element[]): Element;
    elt(tree: Tree, at: number): Element;
}
export declare const parser: MarkdownParser;
export {};
