import * as React from 'react';
import { BaseToolbarProps, ExportedBaseToolbarProps } from '../internals/models/props/toolbar';
import { TimePickerToolbarClasses } from './timePickerToolbarClasses';
import { TimeViewWithMeridiem } from '../internals/models';
export interface TimePickerToolbarProps<TDate> extends BaseToolbarProps<TDate | null, TimeViewWithMeridiem> {
    ampm?: boolean;
    ampmInClock?: boolean;
    classes?: Partial<TimePickerToolbarClasses>;
}
export interface ExportedTimePickerToolbarProps extends ExportedBaseToolbarProps {
    ampm?: boolean;
    ampmInClock?: boolean;
}
/**
 * Demos:
 *
 * - [TimePicker](https://mui.com/x/react-date-pickers/time-picker/)
 * - [Custom components](https://mui.com/x/react-date-pickers/custom-components/)
 *
 * API:
 *
 * - [TimePickerToolbar API](https://mui.com/x/api/date-pickers/time-picker-toolbar/)
 */
declare function TimePickerToolbar<TDate extends unknown>(inProps: TimePickerToolbarProps<TDate>): React.JSX.Element;
declare namespace TimePickerToolbar {
    var propTypes: any;
}
export { TimePickerToolbar };
