import defaultDayjs from "dayjs";
import { IUtils } from "@date-io/core/IUtils";
interface Opts {
    locale?: string;
    /** Make sure that your dayjs instance extends customParseFormat and advancedFormat */
    instance?: typeof defaultDayjs;
    /** @deprecated */
    dayjs?: typeof defaultDayjs;
}
declare type Dayjs = defaultDayjs.Dayjs;
declare type Constructor = (...args: Parameters<typeof defaultDayjs>) => Dayjs;
export default class DayjsUtils implements IUtils<defaultDayjs.Dayjs> {
    dayjs: Constructor;
    locale?: string;
    yearFormat: string;
    yearMonthFormat: string;
    dateTime12hFormat: string;
    dateTime24hFormat: string;
    time12hFormat: string;
    time24hFormat: string;
    dateFormat: string;
    constructor({ locale, instance, dayjs }?: Opts);
    parse(value: any, format: any): defaultDayjs.Dayjs;
    date(value?: any): defaultDayjs.Dayjs;
    isValid(value: any): boolean;
    isNull(date: Dayjs): boolean;
    getDiff(date: Dayjs, comparing: Dayjs, units?: any, float?: any): number;
    isAfter(date: Dayjs, value: Dayjs): boolean;
    isBefore(date: Dayjs, value: Dayjs): boolean;
    isAfterDay(date: Dayjs, value: Dayjs): boolean;
    isBeforeDay(date: Dayjs, value: Dayjs): boolean;
    isBeforeYear(date: Dayjs, value: Dayjs): boolean;
    isAfterYear(date: Dayjs, value: Dayjs): boolean;
    startOfDay(date: Dayjs): defaultDayjs.Dayjs;
    endOfDay(date: Dayjs): defaultDayjs.Dayjs;
    format(date: Dayjs, formatString: string): string;
    formatNumber(numberToFormat: string): string;
    getHours(date: Dayjs): number;
    addDays(date: Dayjs, count: number): defaultDayjs.Dayjs;
    setMonth(date: Dayjs, count: number): defaultDayjs.Dayjs;
    setHours(date: Dayjs, count: number): defaultDayjs.Dayjs;
    getMinutes(date: Dayjs): number;
    setMinutes(date: Dayjs, count: number): defaultDayjs.Dayjs;
    getSeconds(date: Dayjs): number;
    setSeconds(date: Dayjs, count: number): defaultDayjs.Dayjs;
    getMonth(date: Dayjs): number;
    isSameDay(date: Dayjs, comparing: Dayjs): boolean;
    isSameMonth(date: Dayjs, comparing: Dayjs): boolean;
    isSameYear(date: Dayjs, comparing: Dayjs): boolean;
    isSameHour(date: Dayjs, comparing: Dayjs): boolean;
    getMeridiemText(ampm: "am" | "pm"): "AM" | "PM";
    startOfMonth(date: Dayjs): defaultDayjs.Dayjs;
    endOfMonth(date: Dayjs): defaultDayjs.Dayjs;
    getNextMonth(date: Dayjs): defaultDayjs.Dayjs;
    getPreviousMonth(date: Dayjs): defaultDayjs.Dayjs;
    getMonthArray(date: Dayjs): defaultDayjs.Dayjs[];
    getMonthText(date: Dayjs): string;
    getYear(date: Dayjs): number;
    setYear(date: Dayjs, year: number): defaultDayjs.Dayjs;
    mergeDateAndTime(date: Dayjs, time: Dayjs): defaultDayjs.Dayjs;
    getWeekdays(): string[];
    isEqual(value: any, comparing: any): boolean;
    getWeekArray(date: Dayjs): defaultDayjs.Dayjs[][];
    getYearRange(start: Dayjs, end: Dayjs): defaultDayjs.Dayjs[];
    getCalendarHeaderText(date: Dayjs): string;
    getYearText(date: Dayjs): string;
    getDatePickerHeaderText(date: Dayjs): string;
    getDateTimePickerHeaderText(date: Dayjs): string;
    getDayText(date: Dayjs): string;
    getHourText(date: Dayjs, ampm: boolean): string;
    getMinuteText(date: Dayjs): string;
    getSecondText(date: Dayjs): string;
}
export {};
