"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var fs = __importStar(require("fs"));
var path = __importStar(require("path"));
var vm = __importStar(require("vm"));
var create_cache_key_function_1 = __importDefault(require("@jest/create-cache-key-function"));
var core_1 = require("@swc/core");
/**
 * Loads closest package.json in the directory hierarchy
 */
function loadClosestPackageJson(attempts) {
    if (attempts === void 0) { attempts = 1; }
    if (attempts > 5) {
        throw new Error('Can\'t resolve main package.json file');
    }
    var mainPath = attempts === 1 ? './' : Array(attempts).join("../");
    try {
        return require(path.join(process.cwd(), mainPath, 'package.json'));
    }
    catch (e) {
        return loadClosestPackageJson(attempts + 1);
    }
}
var packageConfig = loadClosestPackageJson();
var isEsmProject = packageConfig.type === 'module';
// Jest use the `vm` [Module API](https://nodejs.org/api/vm.html#vm_class_vm_module) for ESM.
// see https://github.com/facebook/jest/issues/9430
var isSupportEsm = 'Module' in vm;
function createTransformer(swcTransformOpts) {
    swcTransformOpts = buildSwcTransformOpts(swcTransformOpts);
    return {
        process: function (src, filename, jestOptions) {
            if (isSupportEsm) {
                set(swcTransformOpts, 'module.type', isEsm(filename, jestOptions) ? 'es6' : 'commonjs');
            }
            return (0, core_1.transformSync)(src, __assign(__assign({}, swcTransformOpts), { filename: filename }));
        },
        getCacheKey: (0, create_cache_key_function_1.default)([], [JSON.stringify(swcTransformOpts)])
    };
}
function buildSwcTransformOpts(swcOptions) {
    if (!swcOptions) {
        var swcrc = path.join(process.cwd(), '.swcrc');
        swcOptions = fs.existsSync(swcrc) ? JSON.parse(fs.readFileSync(swcrc, 'utf-8')) : {};
    }
    if (!isSupportEsm) {
        set(swcOptions, 'module.type', 'commonjs');
    }
    set(swcOptions, 'jsc.transform.hidden.jest', true);
    return swcOptions;
}
function getJestConfig(jestConfig) {
    return 'config' in jestConfig
        // jest 27
        ? jestConfig.config
        // jest 26
        : jestConfig;
}
function isEsm(filename, jestOptions) {
    var _a;
    return (/\.jsx?$/.test(filename) && isEsmProject) ||
        ((_a = getJestConfig(jestOptions).extensionsToTreatAsEsm) === null || _a === void 0 ? void 0 : _a.find(function (ext) { return filename.endsWith(ext); }));
}
function set(obj, path, value) {
    var o = obj;
    var parents = path.split('.');
    var key = parents.pop();
    for (var _i = 0, parents_1 = parents; _i < parents_1.length; _i++) {
        var prop = parents_1[_i];
        if (o[prop] == null)
            o[prop] = {};
        o = o[prop];
    }
    o[key] = value;
}
module.exports = { createTransformer: createTransformer };
