import { Node, mergeAttributes } from '@tiptap/core';

const TableRow = Node.create({
    name: 'tableRow',
    addOptions() {
        return {
            HTMLAttributes: {},
        };
    },
    content: '(tableCell | tableHeader)*',
    tableRole: 'row',
    parseHTML() {
        return [
            { tag: 'tr' },
        ];
    },
    renderHTML({ HTMLAttributes }) {
        return ['tr', mergeAttributes(this.options.HTMLAttributes, HTMLAttributes), 0];
    },
});

export { TableRow, TableRow as default };
//# sourceMappingURL=tiptap-extension-table-row.esm.js.map
