# Installation
> `npm install --save @types/extract-files`

# Summary
This package contains type definitions for extract-files (https://github.com/jaydenseric/extract-files#readme).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/extract-files.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/extract-files/index.d.ts)
````ts
// Type definitions for extract-files 8.1
// Project: https://github.com/jaydenseric/extract-files#readme
// Definitions by: Edward Sammut Alessi <https://github.com/Slessi>
//                 Alex K <https://github.com/lynxtaa>
// Definitions: https://github.com/DefinitelyTyped/DefinitelyTyped

export interface ReactNativeFileOptions {
    uri: string;
    type?: string | undefined;
    name?: string | undefined;
}

export class ReactNativeFile {
    uri: string;
    type?: string | undefined;
    name?: string | undefined;

    constructor(options: ReactNativeFileOptions);
}

export type ExtractableFile = File | Blob | ReactNativeFile;

export function isExtractableFile(value: any): value is ExtractableFile;

export function extractFiles<TFile = ExtractableFile>(
    value: any,
    path?: string,
    isExtractableFile?: (value: any) => value is TFile,
): {
    clone: any;
    files: Map<TFile, string[]>;
};

````

### Additional Details
 * Last updated: Tue, 06 Jul 2021 20:32:51 GMT
 * Dependencies: none
 * Global values: none

# Credits
These definitions were written by [Edward Sammut Alessi](https://github.com/Slessi), and [Alex K](https://github.com/lynxtaa).
