# Installation
> `npm install --save @types/ical`

# Summary
This package contains type definitions for ical (https://github.com/peterbraden/ical.js).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/ical.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/ical/index.d.ts)
````ts
import { RRule } from "rrule";

export type CalendarComponentType = "VEVENT" | "VTODO" | "VJOURNAL" | "VFREEBUSY" | "VTIMEZONE" | "VALARM";

export interface ParamList {
    params: { [key: string]: string };
    val: string;
}

export type FreeBusyType = "FREE" | "BUSY";

export interface FreeBusy {
    type: FreeBusyType;
    start: Date;
    end: Date;
}

// All properties (except type) are optional
// Typed as string | ParamList by default, exceptions listed below
export type CalendarComponent = {
    type: CalendarComponentType;
    summary?: string;
    description?: string;
    url?: string;
    uid?: string;
    location?: string;
    start?: Date;
    end?: Date;
    rrule?: RRule;
    exdate?: { [datestr: string]: Date };
    recurrences?: CalendarComponent[];
    class?: string;
    transparency?: string;
    geo?: Geo;
    completion?: string;
    completed?: Date;
    categories?: string[];
    freebusy?: FreeBusy;
    dtstamp?: Date;
    created?: Date;
    lastmodified?: Date;
    recurrenceid?: Date;
} & { [prop: string]: string | ParamList | undefined };

export interface Geo {
    lat: number;
    lon: number;
}

export interface FullCalendar {
    [uid: string]: CalendarComponent;
}

export function parseICS(icsData: string): FullCalendar;
export function parseFile(filename: string): FullCalendar;

````

### Additional Details
 * Last updated: Tue, 07 Nov 2023 03:09:37 GMT
 * Dependencies: [rrule](https://npmjs.com/package/rrule)

# Credits
These definitions were written by [Nick Clifford](https://github.com/nickbclifford), and [Matej Vilk](https://github.com/iammatis).
