"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createStaticDir = void 0;
const path_1 = require("path");
const fs_extra_1 = require("fs-extra");
async function createStaticDir(prefix) {
    const targetDir = path_1.join(process.cwd(), '.vercel', 'output', 'static', prefix ?? '');
    await fs_extra_1.ensureDir(targetDir);
    await fs_extra_1.copy(path_1.join(process.cwd(), 'public'), targetDir);
}
exports.createStaticDir = createStaticDir;
//# sourceMappingURL=static.js.map