import type { IGatsbyPage, IGatsbyFunction, IRedirect, IGatsbyConfig } from 'gatsby/dist/redux/types';
import Ajv from 'ajv';
export declare type GatsbyPage = Pick<IGatsbyPage, 'mode' | 'path'>;
export interface GatsbyState {
    pages: Array<[string, GatsbyPage]>;
    redirects: Array<GatsbyRedirect>;
    functions: Array<GatsbyFunction>;
    config: GatsbyConfig;
}
export declare type GatsbyFunction = Pick<IGatsbyFunction, 'functionRoute' | 'originalAbsoluteFilePath'>;
export declare type GatsbyRedirect = Pick<IRedirect, 'fromPath' | 'toPath' | 'isPermanent'>;
export declare type GatsbyConfig = Pick<IGatsbyConfig, 'trailingSlash' | 'assetPrefix' | 'pathPrefix'>;
export declare const ajv: Ajv;
export declare const validateGatsbyState: import("ajv").ValidateFunction<GatsbyState>;
//# sourceMappingURL=schemas.d.ts.map