"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.onPostBuild = exports.pluginOptionsSchema = void 0;
const path_1 = __importDefault(require("path"));
// this gets built separately, so import from "dist" instead of "src"
const dist_1 = require("./dist");
const pluginOptionsSchema = ({ Joi, }) => {
    return Joi.object({
        exportPath: Joi.string().optional(),
    });
};
exports.pluginOptionsSchema = pluginOptionsSchema;
const onPostBuild = async ({ store }, pluginOptions) => {
    // validated by `pluginOptionSchema`
    const exportPath = (pluginOptions?.exportPath ??
        path_1.default.join('.vercel', 'output', 'config.json'));
    await dist_1.generateVercelBuildOutputAPI3Output({
        exportPath,
        gatsbyStoreState: store.getState(),
    });
};
exports.onPostBuild = onPostBuild;
//# sourceMappingURL=gatsby-node.js.map