"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createStaticDir = void 0;
const path_1 = require("path");
const build_utils_1 = require("@vercel/build-utils");
async function createStaticDir(prefix) {
    const publicDir = (0, path_1.join)(process.cwd(), 'public');
    const targetDir = (0, path_1.join)(process.cwd(), '.vercel', 'output', 'static', prefix ?? '');
    try {
        await (0, build_utils_1.hardLinkDir)(publicDir, [targetDir]);
    }
    catch (err) {
        console.error(err);
        throw new Error(`Failed to hardlink (or copy) "public" dir files from "${publicDir}" to "${targetDir}".`);
    }
}
exports.createStaticDir = createStaticDir;
//# sourceMappingURL=static.js.map