"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.prepareCache = void 0;
const build_utils_1 = require("@vercel/build-utils");
const path_1 = require("path");
const utils_1 = require("./utils");
const prepareCache = async ({ entrypoint, repoRootPath, workPath, }) => {
    const root = repoRootPath || workPath;
    const mountpoint = (0, path_1.dirname)(entrypoint);
    const entrypointFsDirname = (0, path_1.join)(workPath, mountpoint);
    const packageJsonPath = (0, path_1.join)(entrypointFsDirname, 'package.json');
    const remixRunDevPath = (0, path_1.dirname)(utils_1._require.resolve('@remix-run/dev/package.json', {
        paths: [entrypointFsDirname],
    }));
    const remixConfig = await (0, utils_1.chdirAndReadConfig)(remixRunDevPath, entrypointFsDirname, packageJsonPath);
    const [nodeModulesFiles, cacheDirFiles] = await Promise.all([
        // Cache `node_modules`
        (0, build_utils_1.glob)('**/node_modules/**', root),
        // Cache the Remix "cacheDirectory" (typically `.cache`)
        (0, build_utils_1.glob)((0, path_1.relative)(root, (0, path_1.join)(remixConfig.cacheDirectory, '**')), root),
    ]);
    return { ...nodeModulesFiles, ...cacheDirFiles };
};
exports.prepareCache = prepareCache;
//# sourceMappingURL=prepare-cache.js.map