"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.isESM = exports.ensureResolvable = exports.resolveSemverMinMax = exports.addDependencies = exports.chdirAndReadConfig = exports.syncEnv = exports.getRegExpFromPath = exports.getPathFromRoute = exports.getRouteIterator = exports.isLayoutRoute = exports.calculateRouteConfigHash = exports.getResolvedRouteConfig = exports.findConfig = exports.findEntry = exports._require = void 0;
const semver_1 = __importDefault(require("semver"));
const fs_1 = require("fs");
const path_1 = require("path");
const path_to_regexp_1 = require("path-to-regexp");
const build_utils_1 = require("@vercel/build-utils");
const build_utils_2 = require("@vercel/build-utils");
exports._require = eval('require');
const SPLAT_PATH = '/:params*';
const entryExts = ['.js', '.jsx', '.ts', '.tsx'];
function findEntry(dir, basename) {
    for (const ext of entryExts) {
        const file = (0, path_1.resolve)(dir, basename + ext);
        if ((0, fs_1.existsSync)(file))
            return (0, path_1.relative)(dir, file);
    }
    return undefined;
}
exports.findEntry = findEntry;
const configExts = ['.js', '.cjs', '.mjs'];
function findConfig(dir, basename) {
    for (const ext of configExts) {
        const name = basename + ext;
        const file = (0, path_1.join)(dir, name);
        if ((0, fs_1.existsSync)(file))
            return file;
    }
    return undefined;
}
exports.findConfig = findConfig;
function isEdgeRuntime(runtime) {
    return runtime === 'edge' || runtime === 'experimental-edge';
}
function getResolvedRouteConfig(route, routes, configs) {
    let runtime;
    let regions;
    let maxDuration;
    let memory;
    for (const currentRoute of getRouteIterator(route, routes)) {
        const staticConfig = configs.get(currentRoute);
        if (staticConfig) {
            if (typeof runtime === 'undefined' && staticConfig.runtime) {
                runtime = isEdgeRuntime(staticConfig.runtime) ? 'edge' : 'nodejs';
            }
            if (typeof regions === 'undefined') {
                regions = staticConfig.regions;
            }
            if (typeof maxDuration === 'undefined') {
                maxDuration = staticConfig.maxDuration;
            }
            if (typeof memory === 'undefined') {
                memory = staticConfig.memory;
            }
        }
    }
    if (Array.isArray(regions)) {
        regions = Array.from(new Set(regions)).sort();
    }
    if (runtime === 'edge') {
        return { runtime, regions };
    }
    if (regions && !Array.isArray(regions)) {
        throw new Error(`"regions" for route "${route.id}" must be an array of strings`);
    }
    return { runtime: 'nodejs', regions, maxDuration, memory };
}
exports.getResolvedRouteConfig = getResolvedRouteConfig;
function calculateRouteConfigHash(config) {
    const str = JSON.stringify(config);
    return Buffer.from(str).toString('base64url');
}
exports.calculateRouteConfigHash = calculateRouteConfigHash;
function isLayoutRoute(routeId, routes) {
    return routes.some(r => r.parentId === routeId);
}
exports.isLayoutRoute = isLayoutRoute;
function* getRouteIterator(route, routes) {
    let currentRoute = route;
    do {
        yield currentRoute;
        if (currentRoute.parentId) {
            currentRoute = routes[currentRoute.parentId];
        }
        else {
            break;
        }
    } while (currentRoute);
}
exports.getRouteIterator = getRouteIterator;
function getPathFromRoute(route, routes) {
    if (route.id === 'root' ||
        (route.parentId === 'root' && !route.path && route.index)) {
        return { path: 'index', rePath: '/index' };
    }
    const pathParts = [];
    const rePathParts = [];
    for (const currentRoute of getRouteIterator(route, routes)) {
        if (!currentRoute.path)
            continue;
        const currentRouteParts = currentRoute.path.split('/').reverse();
        for (const part of currentRouteParts) {
            if (part.endsWith('?')) {
                if (part.startsWith(':')) {
                    // Optional path parameter
                    pathParts.push(`(${part.substring(0, part.length - 1)})`);
                    rePathParts.push(part);
                }
                else {
                    // Optional static segment
                    const p = `(${part.substring(0, part.length - 1)})`;
                    pathParts.push(p);
                    rePathParts.push(`${p}?`);
                }
            }
            else {
                pathParts.push(part);
                rePathParts.push(part);
            }
        }
    }
    const path = pathParts.reverse().join('/');
    // Replace "/*" at the end to handle "splat routes"
    let rePath = rePathParts.reverse().join('/');
    rePath =
        rePath === '*' ? SPLAT_PATH : `/${rePath.replace(/\/\*$/, SPLAT_PATH)}`;
    return { path, rePath };
}
exports.getPathFromRoute = getPathFromRoute;
function getRegExpFromPath(rePath) {
    const keys = [];
    const re = (0, path_to_regexp_1.pathToRegexp)(rePath, keys);
    return keys.length > 0 ? re : false;
}
exports.getRegExpFromPath = getRegExpFromPath;
/**
 * Updates the `dest` process.env object to match the `source` one.
 * A function is returned to restore the the `dest` env back to how
 * it was originally.
 */
function syncEnv(source, dest) {
    const originalDest = { ...dest };
    Object.assign(dest, source);
    for (const key of Object.keys(dest)) {
        if (!(key in source)) {
            delete dest[key];
        }
    }
    return () => syncEnv(originalDest, dest);
}
exports.syncEnv = syncEnv;
async function chdirAndReadConfig(remixRunDevPath, dir, packageJsonPath) {
    const { readConfig } = await (_a = (0, path_1.join)(remixRunDevPath, 'dist/config.js'), Promise.resolve().then(() => __importStar(require(_a))));
    const originalCwd = process.cwd();
    // As of Remix v1.14.0, reading the config may trigger adding
    // "isbot" as a dependency, and `npm`/`pnpm`/`yarn` may be invoked.
    // We want to prevent that behavior, so trick `readConfig()`
    // into thinking that "isbot" is already installed.
    let modifiedPackageJson = false;
    const pkgRaw = await fs_1.promises.readFile(packageJsonPath, 'utf8');
    const pkg = JSON.parse(pkgRaw);
    if (!pkg.dependencies?.['isbot']) {
        pkg.dependencies.isbot = 'latest';
        await fs_1.promises.writeFile(packageJsonPath, JSON.stringify(pkg));
        modifiedPackageJson = true;
    }
    // Suppress any warnings emitted from `readConfig()` to avoid
    // printing them > 1 time. They will already be printed during
    // `remix build` when invoking the Build Command.
    const warn = console.warn;
    console.warn = build_utils_1.debug;
    let remixConfig;
    try {
        process.chdir(dir);
        remixConfig = await readConfig(dir);
    }
    finally {
        console.warn = warn;
        process.chdir(originalCwd);
        if (modifiedPackageJson) {
            await fs_1.promises.writeFile(packageJsonPath, pkgRaw);
        }
    }
    return remixConfig;
}
exports.chdirAndReadConfig = chdirAndReadConfig;
/**
 * Runs `npm i ${name}` / `pnpm i ${name}` / `yarn add ${name}`.
 */
function addDependencies(cliType, names, opts = {}) {
    (0, build_utils_1.debug)('Installing additional dependencies:');
    for (const name of names) {
        (0, build_utils_1.debug)(` - ${name}`);
    }
    const args = [];
    if (cliType === 'npm' || cliType === 'pnpm') {
        args.push('install');
        if (opts.saveDev) {
            args.push('--save-dev');
        }
    }
    else {
        // 'yarn'
        args.push('add', '--ignore-workspace-root-check');
        if (opts.saveDev) {
            args.push('--dev');
        }
    }
    // Don't fail if pnpm is being run at the workspace root
    if (cliType === 'pnpm' && opts.cwd) {
        if ((0, fs_1.existsSync)((0, path_1.join)(opts.cwd, 'pnpm-workspace.yaml'))) {
            args.push('--workspace-root');
        }
    }
    return (0, build_utils_1.spawnAsync)(cliType, args.concat(names), opts);
}
exports.addDependencies = addDependencies;
function resolveSemverMinMax(min, max, version) {
    const floored = semver_1.default.intersects(version, `>= ${min}`) ? version : min;
    return semver_1.default.intersects(floored, `<= ${max}`) ? floored : max;
}
exports.resolveSemverMinMax = resolveSemverMinMax;
async function ensureResolvable(start, base, pkgName) {
    try {
        const resolvedPkgPath = exports._require.resolve(`${pkgName}/package.json`, {
            paths: [start],
        });
        const resolvedPath = (0, path_1.dirname)(resolvedPkgPath);
        if (!(0, path_1.relative)(base, resolvedPath).startsWith(`..${path_1.sep}`)) {
            // Resolved path is within the root of the project, so all good
            (0, build_utils_1.debug)(`"${pkgName}" resolved to '${resolvedPath}'`);
            return resolvedPath;
        }
    }
    catch (err) {
        if (err.code !== 'MODULE_NOT_FOUND') {
            throw err;
        }
    }
    // If we got to here then `pkgName` was not resolvable up to the root
    // of the project. Try a couple symlink tricks, otherwise we'll bail.
    // Attempt to find the package in `node_modules/.pnpm` (pnpm)
    const pnpmDir = await (0, build_utils_2.walkParentDirs)({
        base,
        start,
        filename: 'node_modules/.pnpm',
    });
    if (pnpmDir) {
        const prefix = `${pkgName.replace('/', '+')}@`;
        const packages = await fs_1.promises.readdir(pnpmDir);
        const match = packages.find(p => p.startsWith(prefix));
        if (match) {
            const pkgDir = (0, path_1.join)(pnpmDir, match, 'node_modules', pkgName);
            await ensureSymlink(pkgDir, (0, path_1.join)(start, 'node_modules'), pkgName);
            return pkgDir;
        }
    }
    // Attempt to find the package in `node_modules/.store` (npm 9+ linked mode)
    const npmDir = await (0, build_utils_2.walkParentDirs)({
        base,
        start,
        filename: 'node_modules/.store',
    });
    if (npmDir) {
        const prefix = `${(0, path_1.basename)(pkgName)}@`;
        const prefixDir = (0, path_1.join)(npmDir, (0, path_1.dirname)(pkgName));
        const packages = await fs_1.promises.readdir(prefixDir);
        const match = packages.find(p => p.startsWith(prefix));
        if (match) {
            const pkgDir = (0, path_1.join)(prefixDir, match, 'node_modules', pkgName);
            await ensureSymlink(pkgDir, (0, path_1.join)(start, 'node_modules'), pkgName);
            return pkgDir;
        }
    }
    throw new Error(`Failed to resolve "${pkgName}". To fix this error, add "${pkgName}" to "dependencies" in your \`package.json\` file.`);
}
exports.ensureResolvable = ensureResolvable;
async function ensureSymlink(target, nodeModulesDir, pkgName) {
    const symlinkPath = (0, path_1.join)(nodeModulesDir, pkgName);
    const symlinkDir = (0, path_1.dirname)(symlinkPath);
    const relativeTarget = (0, path_1.relative)(symlinkDir, target);
    try {
        const existingTarget = await fs_1.promises.readlink(symlinkPath);
        if (existingTarget === relativeTarget) {
            // Symlink is already the expected value, so do nothing
            return;
        }
        else {
            // If a symlink already exists then delete it if the target doesn't match
            await fs_1.promises.unlink(symlinkPath);
        }
    }
    catch (err) {
        // Ignore when path does not exist or is not a symlink
        if (err.code !== 'ENOENT' && err.code !== 'EINVAL') {
            throw err;
        }
    }
    await fs_1.promises.symlink(relativeTarget, symlinkPath);
    (0, build_utils_1.debug)(`Created symlink for "${pkgName}"`);
}
function isESM(path) {
    // Figure out if the `remix.config` file is using ESM syntax
    let isESM = false;
    try {
        (0, exports._require)(path);
    }
    catch (err) {
        isESM = err.code === 'ERR_REQUIRE_ESM';
    }
    return isESM;
}
exports.isESM = isESM;
//# sourceMappingURL=utils.js.map