"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPluginSymlinks = exports.cleanupGatsbyFiles = exports.injectPlugins = void 0;
const error_utils_1 = require("@vercel/error-utils");
const fs_extra_1 = __importDefault(require("fs-extra"));
const path = __importStar(require("path"));
const semver_1 = __importDefault(require("semver"));
const _shared_1 = require("./_shared");
const PLUGINS = [
    '@vercel/gatsby-plugin-vercel-analytics',
    '@vercel/gatsby-plugin-vercel-builder',
];
const GATSBY_CONFIG_FILE = 'gatsby-config';
const GATSBY_NODE_FILE = 'gatsby-node';
const PLUGIN_PATHS = {
    '@vercel/gatsby-plugin-vercel-analytics': path.dirname(eval('require').resolve(`@vercel/gatsby-plugin-vercel-analytics/package.json`)),
    '@vercel/gatsby-plugin-vercel-builder': path.dirname(eval('require').resolve(`@vercel/gatsby-plugin-vercel-builder/package.json`)),
};
let GLOBAL_EXIT_HANDLER;
async function injectPlugins(detectedVersion, dir) {
    const plugins = new Set();
    if (detectedVersion) {
        const version = semver_1.default.coerce(detectedVersion);
        if (version && semver_1.default.satisfies(version, '>=4.0.0')) {
            plugins.add('@vercel/gatsby-plugin-vercel-builder');
            if (!GLOBAL_EXIT_HANDLER) {
                GLOBAL_EXIT_HANDLER = () => {
                    cleanupGatsbyFiles(dir);
                };
                process.on('exit', GLOBAL_EXIT_HANDLER);
            }
        }
    }
    if (process.env.VERCEL_ANALYTICS_ID) {
        process.env.GATSBY_VERCEL_ANALYTICS_ID = process.env.VERCEL_ANALYTICS_ID;
        plugins.add('@vercel/gatsby-plugin-vercel-analytics');
    }
    if (plugins.size === 0) {
        return false;
    }
    let pluginsStr = 'plugin';
    if (plugins.size > 1) {
        pluginsStr += 's';
    }
    console.log(`Injecting Gatsby.js ${pluginsStr} ${Array.from(plugins)
        .map(p => `"${p}"`)
        .join(', ')}`);
    const ops = [];
    if (plugins.has('@vercel/gatsby-plugin-vercel-analytics')) {
        ops.push(updateGatsbyConfig(dir, ['@vercel/gatsby-plugin-vercel-analytics']));
    }
    if (plugins.has('@vercel/gatsby-plugin-vercel-builder')) {
        ops.push(updateGatsbyNode(dir));
    }
    await Promise.all(ops);
    return true;
}
exports.injectPlugins = injectPlugins;
async function updateGatsbyConfig(dir, plugins) {
    const gatsbyConfigPathTs = path.join(dir, `${GATSBY_CONFIG_FILE}.ts`);
    const gatsbyConfigPathMjs = path.join(dir, `${GATSBY_CONFIG_FILE}.mjs`);
    const gatsbyConfigPathJs = path.join(dir, `${GATSBY_CONFIG_FILE}.js`);
    if (await (0, _shared_1.fileExists)(gatsbyConfigPathTs)) {
        await updateGatsbyConfigTs(gatsbyConfigPathTs, plugins);
    }
    else if (await (0, _shared_1.fileExists)(gatsbyConfigPathMjs)) {
        await updateGatsbyConfigMjs(gatsbyConfigPathMjs, plugins);
    }
    else if (await (0, _shared_1.fileExists)(gatsbyConfigPathJs)) {
        await updateGatsbyConfigJs(gatsbyConfigPathJs, plugins);
    }
    else {
        await fs_extra_1.default.writeFile(gatsbyConfigPathJs, `${GENERATED_FILE_COMMENT}
module.exports = ${JSON.stringify({ plugins })}`);
    }
}
const GENERATED_FILE_COMMENT = `// This file was generated by @vercel/static-build`;
async function updateGatsbyConfigTs(configPath, plugins) {
    const renamedPath = `${configPath}.__vercel_builder_backup__.ts`;
    if (!(await (0, _shared_1.fileExists)(renamedPath))) {
        await fs_extra_1.default.rename(configPath, renamedPath);
    }
    await fs_extra_1.default.writeFile(configPath, `${GENERATED_FILE_COMMENT}
import userConfig from "./gatsby-config.ts.__vercel_builder_backup__.ts";
import type { PluginRef } from "gatsby";

const preferDefault = (m: any) => (m && m.default) || m;

const vercelConfig = Object.assign(
  {},
  preferDefault(userConfig)
);

if (!vercelConfig.plugins) {
  vercelConfig.plugins = [];
}

for (const plugin of ${JSON.stringify(plugins)}) {
  const hasPlugin = vercelConfig.plugins.find(
    (p: PluginRef) =>
      p && (p === plugin || p.resolve === plugin)
  );

  if (!hasPlugin) {
    vercelConfig.plugins = vercelConfig.plugins.slice();
    vercelConfig.plugins.push(plugin);
  }
}

export default vercelConfig;
`);
}
async function updateGatsbyConfigMjs(configPath, plugins) {
    const renamedPath = `${configPath}.__vercel_builder_backup__.mjs`;
    if (!(await (0, _shared_1.fileExists)(renamedPath))) {
        await fs_extra_1.default.rename(configPath, renamedPath);
    }
    await fs_extra_1.default.writeFile(configPath, `${GENERATED_FILE_COMMENT}
import userConfig from "./gatsby-config.mjs.__vercel_builder_backup__.mjs";

const preferDefault = (m) => (m && m.default) || m;

const vercelConfig = Object.assign(
  {},
  preferDefault(userConfig)
);

if (!vercelConfig.plugins) {
  vercelConfig.plugins = [];
}

for (const plugin of ${JSON.stringify(plugins)}) {
  const hasPlugin = vercelConfig.plugins.find(
    (p) => p && (p === plugin || p.resolve === plugin)
  );

  if (!hasPlugin) {
    vercelConfig.plugins = vercelConfig.plugins.slice();
    vercelConfig.plugins.push(plugin);
  }
}

export default vercelConfig;
`);
}
async function updateGatsbyConfigJs(configPath, plugins) {
    const renamedPath = `${configPath}.__vercel_builder_backup__.js`;
    if (!(await (0, _shared_1.fileExists)(renamedPath))) {
        await fs_extra_1.default.rename(configPath, renamedPath);
    }
    await fs_extra_1.default.writeFile(configPath, `${GENERATED_FILE_COMMENT}
const userConfig = require("./gatsby-config.js.__vercel_builder_backup__.js");

const preferDefault = m => (m && m.default) || m;

const vercelConfig = Object.assign(
  {},
  preferDefault(userConfig)
);

if (!vercelConfig.plugins) {
  vercelConfig.plugins = [];
}

for (const plugin of ${JSON.stringify(plugins)}) {
  const hasPlugin = vercelConfig.plugins.find(
    (p) => p && (p === plugin || p.resolve === plugin)
  );

  if (!hasPlugin) {
    vercelConfig.plugins = vercelConfig.plugins.slice();
    vercelConfig.plugins.push(plugin);
  }
}
module.exports = vercelConfig;
`);
}
async function updateGatsbyNode(dir) {
    const gatsbyNodePathTs = path.join(dir, `${GATSBY_NODE_FILE}.ts`);
    const gatsbyNodePathMjs = path.join(dir, `${GATSBY_NODE_FILE}.mjs`);
    const gatsbyNodePathJs = path.join(dir, `${GATSBY_NODE_FILE}.js`);
    if (await (0, _shared_1.fileExists)(gatsbyNodePathTs)) {
        await updateGatsbyNodeTs(gatsbyNodePathTs);
    }
    else if (await (0, _shared_1.fileExists)(gatsbyNodePathMjs)) {
        await updateGatsbyNodeMjs(gatsbyNodePathMjs);
    }
    else if (await (0, _shared_1.fileExists)(gatsbyNodePathJs)) {
        await updateGatsbyNodeJs(gatsbyNodePathJs);
    }
    else {
        await fs_extra_1.default.writeFile(gatsbyNodePathJs, `${GENERATED_FILE_COMMENT}
module.exports = require('@vercel/gatsby-plugin-vercel-builder/gatsby-node.js');`);
    }
}
async function updateGatsbyNodeTs(configPath) {
    const renamedPath = `${configPath}.__vercel_builder_backup__.ts`;
    if (!(await (0, _shared_1.fileExists)(renamedPath))) {
        await fs_extra_1.default.rename(configPath, renamedPath);
    }
    await fs_extra_1.default.writeFile(configPath, `${GENERATED_FILE_COMMENT}
import type { GatsbyNode } from 'gatsby';
import * as vercelBuilder from '@vercel/gatsby-plugin-vercel-builder/gatsby-node.js';
import * as gatsbyNode from './gatsby-node.ts.__vercel_builder_backup__.ts';

export * from './gatsby-node.ts.__vercel_builder_backup__.ts';

export const onPostBuild: GatsbyNode['onPostBuild'] = async (args, options) => {
  if (typeof (gatsbyNode as any).onPostBuild === 'function') {
    await (gatsbyNode as any).onPostBuild(args, options);
  }
  await vercelBuilder.onPostBuild(args, options);
};
`);
}
async function updateGatsbyNodeMjs(configPath) {
    const renamedPath = `${configPath}.__vercel_builder_backup__.mjs`;
    if (!(await (0, _shared_1.fileExists)(renamedPath))) {
        await fs_extra_1.default.rename(configPath, renamedPath);
    }
    await fs_extra_1.default.writeFile(configPath, `${GENERATED_FILE_COMMENT}
import * as vercelBuilder from '@vercel/gatsby-plugin-vercel-builder/gatsby-node.js';
import * as gatsbyNode from './gatsby-node.mjs.__vercel_builder_backup__.mjs';

export * from './gatsby-node.mjs.__vercel_builder_backup__.mjs';

export const onPostBuild = async (args, options) => {
  if (typeof gatsbyNode.onPostBuild === 'function') {
    await gatsbyNode.onPostBuild(args, options);
  }
  await vercelBuilder.onPostBuild(args, options);
};
`);
}
async function updateGatsbyNodeJs(configPath) {
    const renamedPath = `${configPath}.__vercel_builder_backup__.js`;
    if (!(await (0, _shared_1.fileExists)(renamedPath))) {
        await fs_extra_1.default.rename(configPath, renamedPath);
    }
    await fs_extra_1.default.writeFile(configPath, `${GENERATED_FILE_COMMENT}
const vercelBuilder = require('@vercel/gatsby-plugin-vercel-builder/gatsby-node.js');
const gatsbyNode = require('./gatsby-node.js.__vercel_builder_backup__.js');

const origOnPostBuild = gatsbyNode.onPostBuild;

gatsbyNode.onPostBuild = async (args, options) => {
  if (typeof origOnPostBuild === 'function') {
    await origOnPostBuild(args, options);
  }
  await vercelBuilder.onPostBuild(args, options);
};

module.exports = gatsbyNode;
`);
}
// must remain sync because it's called in an exit handler
function cleanupGatsbyFiles(dir) {
    try {
        const backup = '.__vercel_builder_backup__';
        const fileEndings = ['.js', '.ts', '.mjs'];
        for (const fileName of [GATSBY_CONFIG_FILE, GATSBY_NODE_FILE]) {
            for (const fileEnding of fileEndings) {
                const baseFile = `${fileName}${fileEnding}`;
                const baseFilePath = path.join(dir, baseFile);
                const backupFile = `${baseFile}${backup}${fileEnding}`;
                const backupFilePath = path.join(dir, backupFile);
                const baseFileContent = tryReadFileSync(baseFilePath);
                const backupFileContent = tryReadFileSync(backupFilePath);
                if (baseFileContent &&
                    baseFileContent.startsWith(GENERATED_FILE_COMMENT)) {
                    fs_extra_1.default.rmSync(baseFilePath);
                }
                if (backupFileContent) {
                    fs_extra_1.default.renameSync(backupFilePath, baseFilePath);
                }
            }
        }
    }
    catch (error) {
        console.error(error);
        if (GLOBAL_EXIT_HANDLER) {
            process.off('exit', GLOBAL_EXIT_HANDLER);
        }
    }
}
exports.cleanupGatsbyFiles = cleanupGatsbyFiles;
async function createPluginSymlinks(dir) {
    const nodeModulesDir = path.join(dir, 'node_modules');
    await fs_extra_1.default.ensureDir(path.join(nodeModulesDir, '@vercel'));
    await Promise.all(PLUGINS.map(name => fs_extra_1.default.remove(path.join(nodeModulesDir, name))));
    await Promise.all(PLUGINS.map(name => fs_extra_1.default.symlink(PLUGIN_PATHS[name], path.join(nodeModulesDir, name))));
}
exports.createPluginSymlinks = createPluginSymlinks;
function tryReadFileSync(filePath) {
    try {
        return fs_extra_1.default.readFileSync(filePath, 'utf-8');
    }
    catch (error) {
        if ((0, error_utils_1.isErrnoException)(error)) {
            if (error.code !== 'ENOENT') {
                console.error(error);
            }
        }
        else {
            console.error(error);
        }
        return undefined;
    }
}
