"use strict";

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

// eslint-disable-next-line import/no-unassigned-import
require('console-polyfill');

var cuid = require('cuid');

var format = require('@ladjs/format-util');

var formatSpecifiers = require('format-specifiers');

var isError = require('iserror');

var omit = require('lodash.omit');

var parseAppInfo = require('parse-app-info');

var parseErr = require('parse-err');

var safeStringify = require('fast-safe-stringify');

var superagent = require('superagent');

var _require = require('boolean'),
    boolean = _require.boolean;

var pkg = require('../package.json');

var omittedLoggerKeys = new Set(['config', 'log']);
var levels = ['trace', 'debug', 'info', 'warn', 'error', 'fatal'];
var aliases = {
  warning: 'warn',
  err: 'error'
};
var endpoint = 'https://api.cabinjs.com';
var levelError = "`level` invalid, must be: ".concat(levels.join(', ')); // <https://stackoverflow.com/a/43233163>

function isEmpty(value) {
  return value === undefined || value === null || _typeof(value) === 'object' && Object.keys(value).length === 0 || typeof value === 'string' && value.trim().length === 0;
}

function isNull(value) {
  return value === null;
}

function isUndefined(value) {
  return typeof value === 'undefined';
}

function isObject(value) {
  return _typeof(value) === 'object' && value !== null && !Array.isArray(value);
}

function isString(value) {
  return typeof value === 'string';
}

function isFunction(value) {
  return typeof value === 'function';
}

function isBoolean(value) {
  return typeof value === 'boolean';
}

var Axe = /*#__PURE__*/function () {
  function Axe() {
    var _this = this;

    var config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, Axe);

    this.config = Object.assign({
      key: '',
      endpoint: endpoint,
      headers: {},
      timeout: 5000,
      retry: 3,
      showStack: process.env.SHOW_STACK ? boolean(process.env.SHOW_STACK) : true,
      meta: {
        show: process.env.SHOW_META ? boolean(process.env.SHOW_META) : true,
        showApp: process.env.SHOW_META_APP ? boolean(process.env.SHOW_META_APP) : false,
        omittedFields: process.env.OMIT_META_FIELDS ? process.env.OMIT_META_FIELDS.split(',').map(function (s) {
          return s.trim();
        }) : []
      },
      silent: false,
      logger: console,
      name: false,
      level: 'info',
      levels: ['info', 'warn', 'error', 'fatal'],
      // TODO: if user specifies `key` and it is `process.platform === 'browser' || process.browser || env === 'production'` then set `capture` to `true`
      capture: false,
      callback: false,
      appInfo: process.env.APP_INFO ? boolean(process.env.APP_INFO) : true
    }, config); // For backwards compatability

    if (this.config.showMeta) {
      this.config.meta.show = this.config.showMeta;
      delete this.config.showMeta;
    }

    this.appInfo = this.config.appInfo ? isFunction(parseAppInfo) ? parseAppInfo() : false : false;
    this.log = this.log.bind(this); // Inherit methods from parent logger

    var methods = Object.keys(this.config.logger).filter(function (key) {
      return !omittedLoggerKeys.has(key);
    });

    var _iterator = _createForOfIteratorHelper(methods),
        _step;

    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var element = _step.value;
        this[element] = this.config.logger[element];
      } // Bind helper functions for each log level

    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }

    var _iterator2 = _createForOfIteratorHelper(levels),
        _step2;

    try {
      var _loop = function _loop() {
        var element = _step2.value;

        _this[element] = function () {
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }

          return _this.log.apply(_this, _toConsumableArray([element].concat(Array.prototype.slice.call(args))));
        };
      };

      for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
        _loop();
      } // We could have used `auto-bind` but it's not compiled for browser

    } catch (err) {
      _iterator2.e(err);
    } finally {
      _iterator2.f();
    }

    this.setLevel = this.setLevel.bind(this);
    this.getNormalizedLevel = this.getNormalizedLevel.bind(this);
    this.setName = this.setName.bind(this);
    this.setCallback = this.setCallback.bind(this); // Set the logger name

    if (this.config.name) this.setName(this.config.name); // Set the logger level

    this.setLevel(this.config.level); // Aliases

    this.err = this.error;
    this.warning = this.warn;
  }

  _createClass(Axe, [{
    key: "setCallback",
    value: function setCallback(callback) {
      this.config.callback = callback;
    }
  }, {
    key: "setLevel",
    value: function setLevel(level) {
      if (!isString(level) || !levels.includes(level)) throw new Error(levelError); // Support signale logger and other loggers that use `logLevel`

      if (isString(this.config.logger.logLevel)) this.config.logger.logLevel = level;else this.config.logger.level = level; // Adjusts `this.config.levels` array
      // so that it has all proceeding (inclusive)

      this.config.levels = levels.slice(levels.indexOf(level));
    }
  }, {
    key: "getNormalizedLevel",
    value: function getNormalizedLevel(level) {
      if (!isString(level)) return 'info';
      if (isString(aliases[level])) return aliases[level];
      if (!levels.includes(level)) return 'info';
      return level;
    }
  }, {
    key: "setName",
    value: function setName(name) {
      if (!isString(name)) throw new Error('`name` must be a String'); // Support signale logger and other loggers that use `scope`

      if (isString(this.config.logger.scope)) this.config.logger.scope = name;else this.config.logger.name = name;
    } // eslint-disable-next-line complexity

  }, {
    key: "log",
    value: function log(level, message, meta) {
      var _this2 = this;

      var originalArgs = [];
      if (!isUndefined(level)) originalArgs.push(level);
      if (!isUndefined(message)) originalArgs.push(message);
      if (!isUndefined(meta)) originalArgs.push(meta);

      for (var _len2 = arguments.length, args = new Array(_len2 > 3 ? _len2 - 3 : 0), _key2 = 3; _key2 < _len2; _key2++) {
        args[_key2 - 3] = arguments[_key2];
      }

      originalArgs = originalArgs.concat(Array.prototype.slice.call(args));
      var config = this.config;
      var modifier = 0;

      if (isString(level) && isString(aliases[level])) {
        level = aliases[level];
      } else if (isError(level)) {
        meta = message;
        message = level;
        level = 'error';
      } else if (!isString(level) || !levels.includes(level)) {
        meta = message;
        message = level;
        level = this.getNormalizedLevel(level);
        modifier = -1;
      } // Bunyan support (meta, message, ...args)


      var isBunyan = false;

      if ((isObject(message) || Array.isArray(message)) && isString(meta)) {
        isBunyan = true;
        var _meta = meta;
        meta = message;
        message = isString(_meta) && originalArgs.length >= 3 + modifier ? format.apply(void 0, _toConsumableArray(originalArgs.slice(2 + modifier))) : _meta;
      } // If message was undefined then set it to level


      if (isUndefined(message)) message = level; // If only `message` was passed then if it was an Object
      // preserve it as an Object by setting it as meta

      if (originalArgs.slice(1 + modifier).length === 1 && !isString(message) && !isError(message)) {
        meta = {
          message: message
        };
        message = level;
      } else if (!isBunyan && originalArgs.length >= 4 + modifier) {
        // If there are four or more args
        // then infer to use util.format on everything
        message = format.apply(void 0, _toConsumableArray(originalArgs.slice(1 + modifier)));
        meta = {};
      } else if (!isBunyan && originalArgs.length === 3 + modifier && isString(message) && formatSpecifiers.some(function (t) {
        return message.includes(t);
      })) {
        // Otherwise if there are three args and if the `message` contains
        // a placeholder token (e.g. '%s' or '%d' - see above `formatSpecifiers` variable)
        // then we can infer that the `meta` arg passed is used for formatting
        message = format(message, meta);
        meta = {};
      } else if (!isError(message)) {
        if (isError(meta)) {
          meta = {
            err: parseErr(meta)
          }; // } else if (!isPlainObject(meta) && !isUndefined(meta) && !isNull(meta)) {
        } else if (!isObject(meta) && !isUndefined(meta) && !isNull(meta)) {
          // If the `meta` variable passed was not an Object then convert it
          message = format(message, meta);
          meta = {};
        } else if (!isString(message)) {
          // If the message is not a string then we should run `util.format` on it
          // assuming we're formatting it like it was another argument
          // (as opposed to using something like fast-json-stringify)
          message = format(message);
        }
      } // If (!isPlainObject(meta)) meta = {};


      if (!isUndefined(meta) && !isObject(meta)) meta = {
        meta: meta
      };else if (!isObject(meta)) meta = {};
      var error;

      if (isError(message)) {
        error = message;
        if (!isObject(meta.err)) meta.err = parseErr(error);
        var _message = message;
        message = _message.message;
      } else if (isError(meta.err)) {
        error = meta.err;
      } // Omit `callback` from `meta` if it was passed


      var callback = isFunction(config.callback) && (!isBoolean(meta.callback) || meta.callback);
      meta = omit(meta, ['callback']); // Set default level on meta

      meta.level = level; // Add `app` object to metadata

      if (this.appInfo) meta.app = this.appInfo; // Set the body used for returning with and sending logs
      // (and also remove circular references)

      var body = safeStringify({
        message: message,
        meta: meta
      }); // Send to Cabin or other logging service here the `message` and `meta`

      if (config.capture && config.levels.includes(level) && (!isError(error) || !error._captureFailed)) {
        // If the user didn't specify a key
        // and they are using the default endpoint
        // then we should throw an error to them
        if (config.endpoint === endpoint && !config.key) throw new Error("Cabin API key required (e.g. `{ key: 'YOUR-CABIN-API-KEY' })`)\n<https://cabinjs.com>"); // Capture the log over HTTP

        var request = superagent.post(config.endpoint).set('X-Request-Id', cuid()).timeout(config.timeout);
        if (!process.browser) request.set('User-Agent', "axe/".concat(pkg.version)); // Basic auth (e.g. Cabin API key)

        if (config.key) request.auth(config.key); // Set headers if any

        if (!isEmpty(config.headers)) request.set(config.headers);
        request.type('application/json').send(body).retry(config.retry).end(function (error_) {
          if (error_) {
            error_._captureFailed = true;

            _this2.config.logger.error(error_);
          }
        });
      } // Custom callback function (e.g. Slack message)


      if (callback) config.callback(level, message, meta); // Suppress logs if it was silent

      if (config.silent) return body; // Return early if it is not a valid logging level

      if (!config.levels.includes(level)) return body; //
      // determine log method to use
      //
      // if we didn't pass a level as a method
      // (e.g. console.info), then we should still
      // use the logger's `log` method to output
      //
      // and fatal should use error (e.g. in browser)
      //

      var method = level;
      if (modifier === -1) method = 'log';else if (level === 'fatal') method = 'error'; // If there was meta information then output it
      // setup ommitted fields

      var omittedFields = ['level', 'err'].concat(this.config.meta.omittedFields); // Omit app is configured

      if (!this.config.meta.showApp) omittedFields.push('app');
      var omitted = omit(meta, omittedFields); // Show stack trace if necessary (along with any metadata)

      if (method === 'error' && isError(error) && config.showStack) {
        if (!config.meta.show || isEmpty(omitted)) this.config.logger.error(error);else this.config.logger.error(error, omitted);
      } else if (!config.meta.show || isEmpty(omitted)) {
        this.config.logger[method](message);
      } else {
        this.config.logger[method](message, omitted);
      } // Return the parsed body in case we need it


      return body;
    }
  }]);

  return Axe;
}();

module.exports = Axe;