"use strict";

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

var Axe = require('axe');

var isError = require('iserror');

var parseErr = require('parse-err');

var _require = require('./utils'),
    isEmpty = _require.isEmpty,
    isNull = _require.isNull,
    isUndefined = _require.isUndefined,
    isObject = _require.isObject,
    isString = _require.isString,
    isFunction = _require.isFunction;

var message = require('./message');

var middleware = require('./middleware');

var Cabin = /*#__PURE__*/function () {
  function Cabin(config) {
    var _this = this;

    _classCallCheck(this, Cabin);

    this.config = Object.assign({
      key: '',
      capture: null,
      axe: {},
      logger: null,
      meta: {},
      // <https://github.com/niftylettuce/parse-request>
      parseRequest: {},
      // <https://github.com/niftylettuce/parse-err>
      errorProps: [],
      // function that accepts (level, req, res) and returns a string
      // (this is consumed by the cabin middleware and not available in browsers)
      message: message
    }, config); // override key with root key in case user forgot

    if (!isEmpty(this.config.axe) && this.config.key) this.config.axe.key = this.config.key;
    if (!isEmpty(this.config.axe) && typeof this.config.capture === 'boolean') this.config.axe.capture = this.config.capture;
    if (!isEmpty(this.config.axe)) this.config.logger = new Axe(this.config.axe);else if (this.config.key || this.config.capture) this.config.logger = new Axe(Object.assign(this.config.key ? {
      key: this.config.key
    } : {}, this.config.capture ? {
      capture: this.config.capture
    } : {}));else if (!isObject(this.config.logger)) this.config.logger = new Axe(); // bind the logger

    this.logger = this.config.logger; // parse arg helper

    this.parseArg = this.parseArg.bind(this); // bind helper functions for each log level

    var _iterator = _createForOfIteratorHelper(Object.keys(this.logger).filter(function (key) {
      return isFunction(_this.logger[key]);
    })),
        _step;

    try {
      var _loop = function _loop() {
        var level = _step.value;

        _this[level] = function () {
          var _this$logger;

          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }

          if (args[1]) args[1] = _this.parseArg(args[1]);

          (_this$logger = _this.logger)[level].apply(_this$logger, _toConsumableArray(Array.prototype.slice.call(args)));
        };
      };

      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        _loop();
      } // aliases

    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }

    this.err = this.error;
    this.warning = this.warn; // we'd use `auto-bind` package but unfortunately it
    // doesn't have a compiled version without `const` etc

    this.setMeta = this.setMeta.bind(this);
    this.setUser = this.setUser.bind(this);
    if (isFunction(middleware)) this.middleware = middleware.bind(this);
  }

  _createClass(Cabin, [{
    key: "parseArg",
    value: function parseArg() {
      var arg = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      if (isObject(arg)) {
        Object.assign(arg, this.config.meta);
        return arg;
      }

      if (isUndefined(arg) || isNull(arg)) arg = {};else if (isError(arg)) arg = {
        err: parseErr(arg, this.config.errorProps)
      };else if (Array.isArray(arg)) arg = {
        value: arg
      };else if (isString(arg)) arg = {
        value: arg
      };else if (typeof arg === 'number') arg = {
        value: arg
      };else if (isFunction(arg)) arg = {
        value: arg.toString()
      };else arg = {};
      Object.assign(arg, this.config.meta);
      return arg;
    }
  }, {
    key: "setMeta",
    value: function setMeta() {
      var meta = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      this.config.meta = meta;
    }
  }, {
    key: "setUser",
    value: function setUser() {
      var user = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      this.config.meta.user = user;
    }
  }]);

  return Cabin;
}();

module.exports = Cabin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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