"use strict";

var process = require('process');

var c = require('ansi-colors');

var clfDate = require('clf-date');

var ms = require('ms'); // https://github.com/cabinjs/request-received


var requestReceivedStartTime = Symbol.for('request-received.startTime');
var pinoHttpStartTime = Symbol.for('pino-http.startTime');

function getStartTime(request) {
  var startTime = new Date();
  if (request[requestReceivedStartTime] instanceof Date) startTime = request[requestReceivedStartTime];else if (typeof request[requestReceivedStartTime] === 'number') startTime = new Date(request[requestReceivedStartTime]);else if (request[pinoHttpStartTime]) startTime = new Date(request[pinoHttpStartTime]);else if (request._startTime instanceof Date) startTime = request._startTime;else if (typeof request._startTime === 'number') startTime = new Date(request._startTime);
  return startTime;
}

function apacheCommonLogFormat(options) {
  var req = options.req,
      res = options.res,
      ctx = options.ctx;
  var startTime = getStartTime(req);
  return "".concat(ctx ? ctx.ip : req.ip, " - ").concat(clfDate(startTime), " \"").concat(req.method, " ").concat(req.url, " HTTP/").concat(req.httpVersionMajor, ".").concat(req.httpVersionMinor, "\" ").concat(res.statusCode, " ").concat(res.getHeader('content-length') || '-');
}

function devFriendlyLogFormat(options) {
  var req = options.req,
      res = options.res,
      ctx = options.ctx;
  var statusColor = res.statusCode >= 500 ? 'red' : res.statusCode >= 400 ? 'yellow' : res.statusCode >= 300 ? 'cyan' : res.statusCode >= 200 ? 'green' : 'white';
  var responseTime = '-';
  var responseTimeHeader = res.getHeader('x-response-time');

  if (responseTimeHeader) {
    var milliseconds = ms(responseTimeHeader);
    var responseColor = milliseconds >= 1000 ? 'red' : milliseconds >= 500 ? 'magenta' : milliseconds >= 250 ? 'yellow' : milliseconds >= 100 ? 'cyan' : 'green';
    responseTime = c[responseColor]("".concat(milliseconds, " ms"));
  }

  return [ctx ? ctx.ip : req.ip, req.method, req.url, "HTTP/".concat(req.httpVersionMajor, ".").concat(req.httpVersionMinor), c[statusColor](res.statusCode), res.getHeader('content-length') || '-', '-', responseTime].join(' ');
} // https://stackoverflow.com/questions/9234699/understanding-apaches-access-log


module.exports = function (options) {
  // Apache Common Log Format
  // <https://httpd.apache.org/docs/current/logs.html#common>
  // :remote-addr - :remote-user [:date[clf]] ":method :url HTTP/:http-version" :status :res[content-length]
  if (process.env.NODE_ENV === 'production') return apacheCommonLogFormat(options); // Dev-Friendly Log Format
  // :remote-addr :remote-user :method :url HTTP/:http-version :status :res[content-length] - :response-time ms

  return devFriendlyLogFormat(options);
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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