"use strict";

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var onFinished = require('on-finished');

var parseRequest = require('parse-request');

var _require = require('./utils'),
    isFunction = _require.isFunction,
    isUndefined = _require.isUndefined;

module.exports = function () {
  var _this = this;

  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  var isExpress = !isUndefined(args[2]) && isFunction(args[2]);
  var request = isExpress ? args[0] : args[0].req;
  var res = isExpress ? args[1] : args[0].res; // const request = isExpress ? args[0] : args[0].request;
  // const response = isExpress ? args[1] : args[0].response;

  var ctx = args[0];
  var next = isExpress ? args[2] : args[1];
  var logger = {}; //
  // Note that `params` is not named `args` because ESLint doesn't warn:
  // <https://github.com/eslint/eslint/issues/11915>
  //

  var _iterator = _createForOfIteratorHelper(Object.keys(this.logger).filter(function (key) {
    return isFunction(_this.logger[key]);
  })),
      _step;

  try {
    var _loop = function _loop() {
      var key = _step.value;

      logger[key] = function () {
        var _this$logger;

        for (var _len2 = arguments.length, parameters = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
          parameters[_key2] = arguments[_key2];
        }

        parameters[1] = isUndefined(parameters[1]) ? {} : _this.parseArg(parameters[1]); // add `request` object to metadata

        Object.assign(parameters[1], parseRequest(Object.assign(isExpress ? {
          req: request
        } : {
          ctx: ctx
        }, //
        // this symbol was not added until Node v7.7.0
        // and we try to support Node v6.4+
        // <https://github.com/nodejs/node/issues/17745>
        //
        // <https://github.com/nodejs/node/blob/v7.10.0/lib/_http_outgoing.js#L379-L380>
        // <https://github.com/nodejs/node/blob/v7.7.0/lib/_http_outgoing.js#L379-L380>
        // <https://github.com/nodejs/node/blob/v6.4.0/lib/_http_outgoing.js#L351-L352>
        //
        // Note that for the fallback `_headers` all the keys are lowercased
        //
        // But note that in node v12.4.0 for instance this prop is deprecated
        // <https://github.com/nodejs/node/blob/v12.4.0/lib/_http_outgoing.js#L116>
        // So we are left with either the Symbol or use of `getHeaders`
        //
        // HOWEVER automatic properties like Date header aren't
        // set when you do `getHeaders`, they are only written to `_header`
        // and so we need `parse-request` to parse the `responseHeaders`
        // as a String using `http-headers`...
        // <https://github.com/nodejs/node/issues/28302>
        //
        // note that HTTP2 responses do not have a String value
        // for `res._header`, and instead is a Boolean value
        // <https://github.com/nodejs/node/issues/30894>
        // <https://github.com/cabinjs/cabin/issues/133>
        {
          responseHeaders: typeof res._header === 'string' ? res._header : typeof res.getHeaders === 'function' ? res.getHeaders() : null
        }, _this.config.parseRequest)));
        return (_this$logger = _this.logger)[key].apply(_this$logger, _toConsumableArray(Array.prototype.slice.call(parameters)));
      };
    };

    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      _loop();
    } // upon completion of a response we need to log it

  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  onFinished(res, function (err) {
    if (err) logger.error(err);
    var level = 'info';
    if (res.statusCode >= 500) level = 'error';else if (res.statusCode >= 400) level = 'warn';

    var message = _this.config.message(Object.assign({
      level: level,
      req: request,
      res: res
    }, isExpress ? {} : {
      ctx: args[0]
    }));

    if (err) logger[level](message, {
      err: err
    });else logger[level](message);
  }); // add `log` (shorthand) and `logger` methods
  // `req.log`
  // `res.log`
  // `ctx.req`
  // `ctx.res`
  // `ctx.request`
  // `ctx.response`
  // <https://github.com/pinojs/koa-pino-logger/issues/14>
  // <https://github.com/pinojs/koa-pino-logger/blob/master/logger.js#L11>
  // <https://github.com/pinojs/pino-http/blob/master/logger.js#L55>

  if (isExpress) {
    request.log = logger;
    res.log = logger;
    request.logger = logger;
    res.logger = logger;
  } else {
    var _ctx = args[0];
    _ctx.log = logger;
    _ctx.logger = logger;
    _ctx.request.log = logger;
    _ctx.request.logger = logger;
    _ctx.response.log = logger;
    _ctx.response.logger = logger;
  }

  return next();
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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