"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

// <https://stackoverflow.com/a/43233163>
function isEmpty(value) {
  return value === undefined || value === null || _typeof(value) === 'object' && Object.keys(value).length === 0 || typeof value === 'string' && value.trim().length === 0;
}

function isNull(value) {
  return value === null;
}

function isUndefined(value) {
  return typeof value === 'undefined';
}

function isObject(value) {
  return _typeof(value) === 'object' && value !== null && !Array.isArray(value);
}

function isString(value) {
  return typeof value === 'string';
}

function isFunction(value) {
  return typeof value === 'function';
}

module.exports = {
  isEmpty: isEmpty,
  isNull: isNull,
  isUndefined: isUndefined,
  isObject: isObject,
  isString: isString,
  isFunction: isFunction
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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