"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(require("react"));
const types_1 = require("./types");
const context_1 = require("./context");
const initLDClient_1 = __importDefault(require("./initLDClient"));
const utils_1 = require("./utils");
const getFlagsProxy_1 = __importDefault(require("./getFlagsProxy"));
/**
 * This is an async function which initializes LaunchDarkly's JS SDK (`launchdarkly-js-client-sdk`)
 * and awaits it so all flags and the ldClient are ready before the consumer app is rendered.
 *
 * The difference between `withLDProvider` and `asyncWithLDProvider` is that `withLDProvider` initializes
 * `launchdarkly-js-client-sdk` at componentDidMount. This means your flags and the ldClient are only available after
 * your app has mounted. This can result in a flicker due to flag changes at startup time.
 *
 * `asyncWithLDProvider` initializes `launchdarkly-js-client-sdk` at the entry point of your app prior to render.
 * This means that your flags and the ldClient are ready at the beginning of your app. This ensures your app does not
 * flicker due to flag changes at startup time.
 *
 * `asyncWithLDProvider` accepts a config object which is used to initialize `launchdarkly-js-client-sdk`.
 *
 * `asyncWithLDProvider` does not support the `deferInitialization` config option because `asyncWithLDProvider` needs
 * to be initialized at the entry point prior to render to ensure your flags and the ldClient are ready at the beginning
 * of your app.
 *
 * It returns a provider which is a React FunctionComponent which:
 * - saves all flags and the ldClient instance in the context API
 * - subscribes to flag changes and propagate them through the context API
 *
 * @param config - The configuration used to initialize LaunchDarkly's JS SDK
 */
function asyncWithLDProvider(config) {
    return __awaiter(this, void 0, void 0, function* () {
        const { clientSideID, user, flags: targetFlags, options, reactOptions: userReactOptions } = config;
        const reactOptions = Object.assign(Object.assign({}, types_1.defaultReactOptions), userReactOptions);
        const { ldClient, flags: fetchedFlags, error } = yield (0, initLDClient_1.default)(clientSideID, user, options, targetFlags);
        const initialFlags = (options === null || options === void 0 ? void 0 : options.bootstrap) && options.bootstrap !== 'localStorage' ? options.bootstrap : fetchedFlags;
        const LDProvider = ({ children }) => {
            const [ldData, setLDData] = (0, react_1.useState)(() => (Object.assign({ unproxiedFlags: initialFlags }, (0, getFlagsProxy_1.default)(ldClient, initialFlags, reactOptions, targetFlags))));
            (0, react_1.useEffect)(() => {
                function onChange(changes) {
                    const updates = (0, utils_1.getFlattenedFlagsFromChangeset)(changes, targetFlags);
                    if (Object.keys(updates).length > 0) {
                        setLDData(({ unproxiedFlags }) => {
                            const updatedUnproxiedFlags = Object.assign(Object.assign({}, unproxiedFlags), updates);
                            return Object.assign({ unproxiedFlags: updatedUnproxiedFlags }, (0, getFlagsProxy_1.default)(ldClient, updatedUnproxiedFlags, reactOptions, targetFlags));
                        });
                    }
                }
                ldClient.on('change', onChange);
                return function cleanup() {
                    ldClient.off('change', onChange);
                };
            }, []);
            const { flags, flagKeyMap } = ldData;
            return react_1.default.createElement(context_1.Provider, { value: { flags, flagKeyMap, ldClient, error } }, children);
        };
        return LDProvider;
    });
}
exports.default = asyncWithLDProvider;
//# sourceMappingURL=asyncWithLDProvider.js.map