"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(require("react"));
const types_1 = require("./types");
const context_1 = require("./context");
const initLDClient_1 = __importDefault(require("./initLDClient"));
const utils_1 = require("./utils");
const getFlagsProxy_1 = __importDefault(require("./getFlagsProxy"));
/**
 * The `LDProvider` is a component which accepts a config object which is used to
 * initialize `launchdarkly-js-client-sdk`.
 *
 * This Provider does three things:
 * - It initializes the ldClient instance by calling `launchdarkly-js-client-sdk` initialize on `componentDidMount`
 * - It saves all flags and the ldClient instance in the context API
 * - It subscribes to flag changes and propagate them through the context API
 *
 * Because the `launchdarkly-js-client-sdk` in only initialized on `componentDidMount`, your flags and the
 * ldClient are only available after your app has mounted. This can result in a flicker due to flag changes at
 * startup time.
 *
 * This component can be used as a standalone provider. However, be mindful to only include the component once
 * within your application. This provider is used inside the `withLDProviderHOC` and can be used instead to initialize
 * the `launchdarkly-js-client-sdk`. For async initialization, check out the `asyncWithLDProvider` function
 */
class LDProvider extends react_1.Component {
    constructor(props) {
        super(props);
        this.getReactOptions = () => (Object.assign(Object.assign({}, types_1.defaultReactOptions), this.props.reactOptions));
        this.subscribeToChanges = (ldClient) => {
            const { flags: targetFlags } = this.props;
            ldClient.on('change', (changes) => {
                const reactOptions = this.getReactOptions();
                const updates = (0, utils_1.getFlattenedFlagsFromChangeset)(changes, targetFlags);
                const unproxiedFlags = Object.assign(Object.assign({}, this.state.unproxiedFlags), updates);
                if (Object.keys(updates).length > 0) {
                    this.setState(Object.assign({ unproxiedFlags }, (0, getFlagsProxy_1.default)(ldClient, unproxiedFlags, reactOptions, targetFlags)));
                }
            });
        };
        this.initLDClient = () => __awaiter(this, void 0, void 0, function* () {
            const { clientSideID, flags, options, user } = this.props;
            let ldClient = yield this.props.ldClient;
            const reactOptions = this.getReactOptions();
            let unproxiedFlags;
            let error;
            if (ldClient) {
                unproxiedFlags = (0, utils_1.fetchFlags)(ldClient, flags);
            }
            else {
                const initialisedOutput = yield (0, initLDClient_1.default)(clientSideID, user, options, flags);
                unproxiedFlags = initialisedOutput.flags;
                ldClient = initialisedOutput.ldClient;
                error = initialisedOutput.error;
            }
            this.setState(Object.assign(Object.assign({ unproxiedFlags }, (0, getFlagsProxy_1.default)(ldClient, unproxiedFlags, reactOptions, flags)), { ldClient, error }));
            this.subscribeToChanges(ldClient);
        });
        const { options } = props;
        this.state = {
            flags: {},
            unproxiedFlags: {},
            flagKeyMap: {},
            ldClient: undefined,
        };
        if (options) {
            const { bootstrap } = options;
            if (bootstrap && bootstrap !== 'localStorage') {
                const { useCamelCaseFlagKeys } = this.getReactOptions();
                this.state = {
                    flags: useCamelCaseFlagKeys ? (0, utils_1.camelCaseKeys)(bootstrap) : bootstrap,
                    unproxiedFlags: bootstrap,
                    flagKeyMap: {},
                    ldClient: undefined,
                };
            }
        }
    }
    componentDidMount() {
        return __awaiter(this, void 0, void 0, function* () {
            const { user, deferInitialization } = this.props;
            if (deferInitialization && !user) {
                return;
            }
            yield this.initLDClient();
        });
    }
    componentDidUpdate(prevProps) {
        return __awaiter(this, void 0, void 0, function* () {
            const { user, deferInitialization } = this.props;
            const userJustLoaded = !prevProps.user && user;
            if (deferInitialization && userJustLoaded) {
                yield this.initLDClient();
            }
        });
    }
    render() {
        const { flags, flagKeyMap, ldClient, error } = this.state;
        return react_1.default.createElement(context_1.Provider, { value: { flags, flagKeyMap, ldClient, error } }, this.props.children);
    }
}
exports.default = LDProvider;
//# sourceMappingURL=provider.js.map