"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.withLDProvider = void 0;
const React = __importStar(require("react"));
const types_1 = require("./types");
const provider_1 = __importDefault(require("./provider"));
const hoist_non_react_statics_1 = __importDefault(require("hoist-non-react-statics"));
/**
 * `withLDProvider` is a function which accepts a config object which is used to
 * initialize `launchdarkly-js-client-sdk`.
 *
 * This HOC handles passing configuration to the `LDProvider`, which does the following:
 * - It initializes the ldClient instance by calling `launchdarkly-js-client-sdk` initialize on `componentDidMount`
 * - It saves all flags and the ldClient instance in the context API
 * - It subscribes to flag changes and propagate them through the context API
 *
 * The difference between `withLDProvider` and `asyncWithLDProvider` is that `withLDProvider` initializes
 * `launchdarkly-js-client-sdk` at `componentDidMount`. This means your flags and the ldClient are only available after
 * your app has mounted. This can result in a flicker due to flag changes at startup time.
 *
 * `asyncWithLDProvider` initializes `launchdarkly-js-client-sdk` at the entry point of your app prior to render.
 * This means that your flags and the ldClient are ready at the beginning of your app. This ensures your app does not
 * flicker due to flag changes at startup time.
 *
 * @param config - The configuration used to initialize LaunchDarkly's JS SDK
 * @return A function which accepts your root React component and returns a HOC
 */
function withLDProvider(config) {
    return function withLDProviderHoc(WrappedComponent) {
        const { reactOptions: userReactOptions } = config;
        const reactOptions = Object.assign(Object.assign({}, types_1.defaultReactOptions), userReactOptions);
        const providerProps = Object.assign(Object.assign({}, config), { reactOptions });
        function HoistedComponent(props) {
            return (React.createElement(provider_1.default, Object.assign({}, providerProps),
                React.createElement(WrappedComponent, Object.assign({}, props))));
        }
        (0, hoist_non_react_statics_1.default)(HoistedComponent, WrappedComponent);
        return HoistedComponent;
    };
}
exports.withLDProvider = withLDProvider;
exports.default = withLDProvider;
//# sourceMappingURL=withLDProvider.js.map