import { IsomorphicResponse, BatchInterceptor, Interceptor, HttpRequestEventMap } from '@mswjs/interceptors';
import { J as LifeCycleEventsMap, S as SetupApi, b as RequestHandler, n as SharedOptions } from './SetupApi-8ab693f7.js';

declare type ServerLifecycleEventsMap = LifeCycleEventsMap<IsomorphicResponse>;
declare class SetupServerApi extends SetupApi<ServerLifecycleEventsMap> {
    protected readonly interceptor: BatchInterceptor<Array<Interceptor<HttpRequestEventMap>>, HttpRequestEventMap>;
    private resolvedOptions;
    constructor(interceptors: Array<{
        new (): Interceptor<HttpRequestEventMap>;
    }>, ...handlers: Array<RequestHandler>);
    /**
     * Subscribe to all requests that are using the interceptor object
     */
    private init;
    listen(options?: Partial<SharedOptions>): void;
    printHandlers(): void;
    close(): void;
}

export { SetupServerApi as S, ServerLifecycleEventsMap as a };
