"use strict";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

const process = require('process');

const cluster = require('cluster');

const os = require('os');

const LastCommitLog = require('last-commit-log');

const _ = require('lodash');

const readPkgUp = require('read-pkg-up');

const semver = require('semver');

const hasWorkerThreads = semver.satisfies(process.version, '>=12.11.0');
let worker_threads; // eslint-disable-next-line node/no-unsupported-features/node-builtins

if (hasWorkerThreads) worker_threads = require('worker_threads');
const OS_METHODS = ['arch', 'cpus', 'endianness', 'freemem', 'getPriority', // => priority
'homedir', 'hostname', 'loadavg', 'networkInterfaces', // => network_interfaces
'platform', 'release', 'tmpdir', 'totalmem', 'type', 'uptime', 'userInfo' // => user
]; // `os.version` added in 13.11.0
// https://nodejs.org/api/os.html#os_os_version

if (semver.satisfies(process.version, '>=13.11.0')) {
  OS_METHODS.push('version');
} //
// Information about the app.
//
// The git infos can be missing if the project has no commit yet
// or is not connected to a git repo.
//
// * name - The name of the app
// * version - The version of the app
// * node - NodeJS version
// * hash - Last git commit hash
// * tag - Last git tag, if any
// * environment - Nodejs environment the app is run in
// * hostname - Name of the computer the app is run on
// * pid - Process ID of the app
// * cluster - Cluster info of the app
// * os - OS info of the app
//
// Retrieves informations about the current running app.
// eslint-disable-next-line complexity


function parseAppInfo() {
  let packageInfo = {};

  try {
    packageInfo = readPkgUp.sync(); // eslint-disable-next-line no-unused-vars
  } catch (err) {}

  const info = {};

  if (typeof packageInfo === 'object' && typeof packageInfo.packageJson === 'object') {
    if (typeof packageInfo.packageJson.name === 'string') info.name = packageInfo.packageJson.name;
    if (typeof packageInfo.packageJson.version === 'string') info.version = packageInfo.packageJson.version;
  }

  const lastCommitLog = new LastCommitLog();
  let hash;
  let gitTag;

  try {
    var _lastCommitLog$getLas = lastCommitLog.getLastCommitSync();

    hash = _lastCommitLog$getLas.hash;
    gitTag = _lastCommitLog$getLas.gitTag;
  } catch (err) {}

  const lastCommit = {
    hash
  };
  if (gitTag) lastCommit.tag = gitTag;
  const _process$env = process.env,
        NODE_ENV = _process$env.NODE_ENV,
        HOSTNAME = _process$env.HOSTNAME;

  const _cluster = _.pick(cluster, ['worker', 'isMaster', 'isWorker', 'schedulingPolicy']);

  if (_.isObject(_cluster.worker)) {
    _cluster.worker = _.pick(_cluster.worker, ['id', 'process', 'exitedAfterDisconnect', 'isConnected', 'isDead']);

    if (_.isObject(_cluster.worker.process)) {
      _cluster.worker.process = _.pick(_cluster.worker.process, ['pid', 'connected', 'killed', 'signalCode', 'exitCode']);
    }

    if (_.isFunction(_cluster.worker.isConnected)) _cluster.worker.isConnected = _cluster.worker.isConnected();
    if (_.isFunction(_cluster.worker.isDead)) _cluster.worker.isDead = _cluster.worker.isDead();
  }

  const _os = {};

  var _iterator = _createForOfIteratorHelper(OS_METHODS),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      const method = _step.value;
      let key = method;

      switch (method) {
        case 'getPriority':
          {
            key = 'priority';
            break;
          }

        case 'networkInterfaces':
          {
            key = 'network_interfaces';
            break;
          }

        case 'userInfo':
          {
            key = 'user';
            break;
          }

        default:
          {
            key = method;
            break;
          }
      }

      _os[key] = os[method]();
    } // worker_threads

  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  let _worker_threads = {};

  if (hasWorkerThreads) {
    _worker_threads = _.pick(worker_threads, ['isMainThread', semver.satisfies(process.version, '>=12.16.0') && 'resourceLimits', 'threadId', 'workerData']);

    if (_.isObject(_worker_threads.resourceLimits)) {
      _worker_threads.resourceLimits = _.pick(_worker_threads.resourceLimits, ['maxYoungGenerationSizeMb', 'maxOldGenerationSizeMb', 'codeRangeSizeMb', 'stackSizeMb']);
    }
  }

  return _objectSpread(_objectSpread(_objectSpread({}, info), {}, {
    node: process.version
  }, lastCommit), {}, {
    environment: NODE_ENV || 'development',
    hostname: HOSTNAME || os.hostname(),
    pid: process.pid,
    cluster: _cluster,
    os: _os,
    worker_threads: _worker_threads
  });
}

module.exports = parseAppInfo;