"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var ObjectId = require('bson-objectid');

var Url = require('url-parse');

var convertHrtime = require('convert-hrtime');

var cookie = require('cookie');

var creditCardType = require('credit-card-type');

var debug = require('debug')('parse-request');

var hrtime = require('browser-hrtime');

var httpHeaders = require('http-headers');

var isArrayBuffer = require('is-array-buffer');

var isBuffer = require('is-buffer');

var isStream = require('is-stream');

var isUUID = require('is-uuid');

var ms = require('ms');

var noCase = require('no-case');

var querystring = require('qs');

var rfdc = require('rfdc');

var safeStringify = require('fast-safe-stringify');

var sensitiveFields = require('sensitive-fields'); // https://github.com/cabinjs/request-received


var startTime = Symbol.for('request-received.startTime');
var pinoHttpStartTime = Symbol.for('pino-http.startTime');
var disableBodyParsingSymbol = Symbol.for('parse-request.disableBodyParsing');
var disableQueryParsingSymbol = Symbol.for('parse-request.disableQueryParsing');
var disableFileParsingSymbol = Symbol.for('parse-request.disableFileParsing');
var hashMapIds = {
  _id: true,
  id: true
};
var regexId = /_id$/;

function maskArray(obj, options) {
  var arr = [];

  var _iterator = _createForOfIteratorHelper(obj.entries()),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var _step$value = _slicedToArray(_step.value, 2),
          i = _step$value[0],
          element = _step$value[1];

      arr[i] = maskSpecialTypes(element, options);
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  return arr;
}

function maskSpecialTypes(obj, options) {
  options = Object.assign({
    maskBuffers: true,
    maskStreams: true,
    checkObjectId: true
  }, options);
  if (_typeof(obj) !== 'object') return obj; // we need to return an array if passed an array

  if (Array.isArray(obj)) return maskArray(obj, options); // if it was a bson objectid return early

  if (options.checkObjectId && ObjectId.isValid(obj)) return obj.toString(); // check if it was a stream

  if (options.maskStreams && isStream(obj)) return {
    type: 'Stream'
  }; // check if it was a buffer or array buffer
  // before iterating over the object's keys

  if (options.maskBuffers) {
    if (isBuffer(obj)) return {
      type: 'Buffer',
      byteLength: obj.byteLength
    };
    if (isArrayBuffer(obj)) return {
      type: 'ArrayBuffer',
      byteLength: obj.byteLength
    };
  } // we need to return an object if passed an object


  var masked = {}; // for...in is much faster than Object.entries or any alternative
  // TODO: we should optimize this further in the future

  for (var key in obj) {
    if (_typeof(obj[key]) === 'object') {
      if (Array.isArray(obj[key])) {
        masked[key] = maskSpecialTypes(obj[key], options);
      } else if (options.maskStreams && isStream(obj[key])) {
        masked[key] = {
          type: 'Stream'
        };
      } else if (options.maskBuffers && isBuffer(obj[key])) {
        masked[key] = {
          type: 'Buffer',
          byteLength: obj[key].byteLength
        };
      } else if (options.maskBuffers && isArrayBuffer(obj[key])) {
        masked[key] = {
          type: 'ArrayBuffer',
          byteLength: obj[key].byteLength
        };
      } else {
        masked[key] = maskSpecialTypes(obj[key], options);
      }
    } else {
      masked[key] = obj[key];
    }
  }

  return masked;
}

function pick(object, keys) {
  return keys.reduce(function (obj, key) {
    if (object && Object.prototype.hasOwnProperty.call(object, key)) {
      obj[key] = object[key];
    }

    return obj;
  }, {});
}

function isNull(val) {
  return val === null;
}

function isUndefined(val) {
  return typeof val === 'undefined';
}

function isObject(val) {
  return _typeof(val) === 'object' && val !== null && !Array.isArray(val);
}

function isString(val) {
  return typeof val === 'string';
} // <https://github.com/braintree/credit-card-type/issues/90>


function isCreditCard(val) {
  var digits = val.replace(/\D/g, '');
  var types = creditCardType(digits);
  if (!Array.isArray(types) || types.length === 0) return false;
  var match = false;

  var _iterator2 = _createForOfIteratorHelper(types),
      _step2;

  try {
    for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
      var type = _step2.value;
      if (match) break; // can match any one of the lengths

      if (!Array.isArray(type.lengths) || type.lengths.length === 0) continue;

      for (var l = 0; l < type.lengths.length; l++) {
        var len = type.lengths[l];

        if (Number.isFinite(len) && len === digits.length) {
          match = true;
          break;
        }
      }
    }
  } catch (err) {
    _iterator2.e(err);
  } finally {
    _iterator2.f();
  }

  return match;
}

function isID(val, options) {
  // if it was an objectid return early
  if (options.checkObjectId && ObjectId.isValid(val)) return true; // if it was a cuid return early
  // <https://github.com/ericelliott/cuid/issues/88#issuecomment-339848922>

  if (options.checkCuid && val.indexOf('c') === 0 && val.length >= 7) return true; // if it was a uuid v1-5 return early

  if (options.checkUUID && isUUID.anyNonNil(val)) return true;
  return false;
}

function maskString(key, val, props, options) {
  var isKeyString = isString(key);

  if (options.isHeaders) {
    // headers are case-insensitive
    props = props.map(function (prop) {
      return prop.toLowerCase();
    });

    if (props.includes('referer') || props.includes('referrer')) {
      if (!props.includes('referer')) props.push('referer');
      if (!props.includes('referrer')) props.push('referrer');
    }
  }

  var notIncludedInProps = !isKeyString || !props.includes(key);

  if (!options.isHeaders) {
    // check if it closely resembles a primary ID and return early if so
    if (isKeyString && options.checkId) {
      // _id
      // id
      // ID
      // Id
      if (hashMapIds[key.toLowerCase()]) return val; // product_id
      // product-id
      // product[id]
      // productId
      // productID

      var snakeCase = noCase(key, null, '_');
      if (regexId.test(snakeCase)) return val;
    } // if it was an objectid, cuid, or uuid return early


    if (isID(val, options) && notIncludedInProps) return val; // if it was a credit card then replace all digits with asterisk

    if (options.maskCreditCards && isCreditCard(val)) return val.replace(/[^\D\s]/g, '*');
  }

  if (notIncludedInProps) return val; // replace only the authentication <credentials> portion with asterisk
  // Authorization: <type> <credentials>

  if (options.isHeaders && key === 'authorization') return "".concat(val.split(' ')[0], " ").concat(val.slice(val.indexOf(' ') + 1).replace(/./g, '*'));
  return val.replace(/./g, '*');
}

function headersToLowerCase(headers) {
  if (_typeof(headers) !== 'object' || Array.isArray(headers)) return headers;
  var lowerCasedHeaders = {};

  for (var header in headers) {
    if (isString(headers[header])) lowerCasedHeaders[header.toLowerCase()] = headers[header];
  }

  return lowerCasedHeaders;
}

function maskProps(obj, props, options) {
  options = Object.assign({
    maskCreditCards: true,
    isHeaders: false,
    checkId: true,
    checkCuid: true,
    checkObjectId: true,
    checkUUID: true
  }, options);
  if (isString(obj)) return maskString(null, obj, props, options); // for...in is much faster than Object.entries or any alternative

  for (var key in obj) {
    if (_typeof(obj[key]) === 'object') obj[key] = maskProps(obj[key], props, options);else if (isString(obj[key])) obj[key] = maskString(key, obj[key], props, options);
  }

  return obj;
} // inspired by raven's parseRequest
// eslint-disable-next-line complexity


var parseRequest = function parseRequest() {
  var config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var start = hrtime();
  var id = new ObjectId();
  config = Object.assign({
    req: false,
    ctx: false,
    responseHeaders: '',
    userFields: ['id', 'email', 'full_name', 'ip_address'],
    sanitizeFields: sensitiveFields,
    sanitizeHeaders: ['authorization'],
    maskCreditCards: true,
    maskBuffers: true,
    maskStreams: true,
    checkId: true,
    checkCuid: true,
    checkObjectId: true,
    checkUUID: true,
    // <https://github.com/davidmarkclements/rfdc>
    rfdc: {
      proto: false,
      circles: false
    },
    parseBody: true,
    parseQuery: true,
    parseFiles: true
  }, config);
  var clone = rfdc(config.rfdc);
  var _config = config,
      req = _config.req,
      ctx = _config.ctx,
      responseHeaders = _config.responseHeaders,
      userFields = _config.userFields,
      sanitizeFields = _config.sanitizeFields,
      sanitizeHeaders = _config.sanitizeHeaders,
      maskCreditCards = _config.maskCreditCards,
      maskBuffers = _config.maskBuffers,
      maskStreams = _config.maskStreams,
      checkId = _config.checkId,
      checkCuid = _config.checkCuid,
      checkObjectId = _config.checkObjectId,
      checkUUID = _config.checkUUID,
      parseBody = _config.parseBody,
      parseQuery = _config.parseQuery,
      parseFiles = _config.parseFiles; // do not allow both `req` and `ctx` to be specified

  if (req && ctx) throw new Error('You must either use `req` (Express/Connect) or `ctx` (Koa) option, but not both');
  var nodeReq = ctx ? ctx.req : req ? req : {};
  var maskPropsOptions = {
    maskCreditCards: maskCreditCards,
    checkId: checkId,
    checkCuid: checkCuid,
    checkObjectId: checkObjectId,
    checkUUID: checkUUID
  };
  var maskSpecialTypesOptions = {
    maskBuffers: maskBuffers,
    maskStreams: maskStreams,
    checkObjectId: checkObjectId
  };
  var requestHeaders = nodeReq.headers;
  var headers;
  if (requestHeaders) headers = maskProps(headersToLowerCase(requestHeaders), sanitizeHeaders, {
    isHeaders: true
  });
  var method;
  if (ctx) method = ctx.method;else if (req) method = req.method; // inspired from `preserve-qs` package

  var originalUrl;
  if (ctx) originalUrl = ctx.originalUrl || ctx.url;else if (req) originalUrl = req.originalUrl || req.url;
  var query;
  var absoluteUrl;

  if (originalUrl) {
    originalUrl = new Url(originalUrl, {}); // parse query, path, and origin to prepare absolute Url

    query = Url.qs.parse(originalUrl.query);
    var path = originalUrl.origin === 'null' ? originalUrl.pathname : "".concat(originalUrl.origin).concat(originalUrl.pathname);
    var qs = Url.qs.stringify(query, true);
    absoluteUrl = path + qs;
  } // default to the user object


  var user = {};
  var parsedUser;
  if (ctx && isObject(ctx.state.user)) parsedUser = ctx.state.user;else if (req && isObject(req.user)) parsedUser = req.user;

  if (parsedUser) {
    try {
      user = typeof parsedUser.toJSON === 'function' ? parsedUser.toJSON() : typeof parsedUser.toObject === 'function' ? parsedUser.toObject() : clone(parsedUser);
    } catch (err) {
      debug(err);

      try {
        user = JSON.parse(safeStringify(parsedUser));
      } catch (err) {
        debug(err);
      }
    }
  }

  var ip = ctx ? ctx.ip : req ? req.ip : null;
  if (ip && !isString(user.ip_address)) user.ip_address = ip;
  if (user && Array.isArray(userFields) && userFields.length > 0) user = pick(user, userFields); // recursively search through user and filter out passwords from it

  if (user) user = maskProps(user, sanitizeFields, maskPropsOptions);
  var body;
  var originalBody = ctx ? ctx.request._originalBody || ctx.request.body : req ? req._originalBody || req.body : null;

  if (originalBody && parseBody && !nodeReq[disableBodyParsingSymbol]) {
    //
    // recursively search through body and filter out passwords from it
    // <https://github.com/niftylettuce/frisbee/issues/68>
    // <https://github.com/bitinn/node-fetch/blob/master/src/request.js#L75-L78>
    //
    if (!['GET', 'HEAD'].includes(method) && !isUndefined(originalBody)) body = clone(maskBuffers || maskStreams ? maskSpecialTypes(originalBody, maskSpecialTypesOptions) : originalBody);
    body = maskProps(body, sanitizeFields, maskPropsOptions);
    if (!isUndefined(body) && !isNull(body) && !isString(body)) body = safeStringify(body);
  } // parse the cookies (if any were set)


  var cookies;
  if (headers && headers.cookie) cookies = cookie.parse(headers.cookie);
  var result = {
    id: id.toString(),
    //
    // NOTE: regarding the naming convention of `timestamp`, it seems to be the
    // most widely used and supported property name across logging services
    //
    timestamp: id.getTimestamp().toISOString()
  };
  if (ctx || req) result.request = {};
  if (method) result.request.method = method;
  if (headers) result.request.headers = headers;
  if (cookies) result.request.cookies = cookies;
  if (absoluteUrl) result.request.url = absoluteUrl;
  if (user) result.user = user;

  if (query) {
    if (parseQuery && !nodeReq[disableQueryParsingSymbol]) query = maskProps(querystring.parse(query), sanitizeFields);
    result.request.query = query;
  }

  if (originalBody && parseBody && body && !nodeReq[disableBodyParsingSymbol]) result.request.body = body; //
  // Also note that there is no standard for setting a request received time.
  //
  // Examples:
  //
  // 1) koa-req-logger uses `ctx.start`
  // <https://github.com/DrBarnabus/koa-req-logger/blob/master/src/index.ts#L198>
  //
  // 2) morgan uses `req._startAt` and `req._startTime` which are not
  // req._startAt = process.hrtime()
  // req._startTime = new Date()
  // <https://github.com/expressjs/morgan/blob/master/index.js#L500-L508>
  //
  // 3) pino uses `Symbol('startTime')` but it does not expose it easily
  // <https://github.com/pinojs/pino-http/issues/65>
  //
  // 4) response-time does not expose anything
  // <https://github.com/expressjs/response-time/pull/18>
  //
  // Therefore we created `request-received` middleware that is required
  // to be used in order for `request.timestamp` to be populated with ISO-8601
  // <https://github.com/cabinjs/request-received>
  //
  // We also opened the following PR's in an attempt to make this a drop-in:
  //
  // * https://github.com/pinojs/pino-http/pull/67
  // * https://github.com/expressjs/morgan/pull/201
  // * https://github.com/expressjs/response-time/pull/20
  // * https://github.com/DataDog/node-connect-datadog/pull/7
  // * https://github.com/DrBarnabus/koa-req-logger/pull/2
  //
  // add request.timestamp (parse req[$x] variable)

  if (nodeReq[startTime] instanceof Date) result.request.timestamp = nodeReq[startTime].toISOString();else if (typeof nodeReq[startTime] === 'number') result.request.timestamp = new Date(nodeReq[startTime]).toISOString();else if (typeof nodeReq[pinoHttpStartTime] === 'number') result.request.timestamp = new Date(nodeReq[pinoHttpStartTime]).toISOString();else if (nodeReq._startTime instanceof Date) result.request.timestamp = nodeReq._startTime.toISOString();else if (typeof nodeReq._startTime === 'number') result.request.timestamp = new Date(nodeReq._startTime).toISOString(); //
  // conditionally add a `response` object if and only if
  // `responseHeaders` option was passed, and it was a non-empty string or object
  //

  if (isObject(responseHeaders) && Object.keys(responseHeaders).length > 0) {
    result.response = {};
    result.response.headers = clone(responseHeaders);
  } else if (isString(responseHeaders)) {
    // <https://github.com/nodejs/node/issues/28302>
    var parsedHeaders = httpHeaders(responseHeaders);
    result.response = {};

    if (isObject(parsedHeaders.headers)) {
      result.response.headers = parsedHeaders.headers; // parse the status line
      // <https://www.w3.org/Protocols/rfc2616/rfc2616-sec6.html#sec6.1>

      if (isObject(parsedHeaders.version) && typeof parsedHeaders.version.major === 'number' && typeof parsedHeaders.version.minor === 'number') result.response.http_version = "".concat(parsedHeaders.version.major, ".").concat(parsedHeaders.version.minor);
      if (typeof parsedHeaders.statusCode === 'number') result.response.status_code = parsedHeaders.statusCode;
      if (isString(parsedHeaders.statusMessage)) result.response.reason_phrase = parsedHeaders.statusMessage;
    } else {
      result.response.headers = parsedHeaders;
    }
  }

  if (result.response && result.response.headers) {
    result.response.headers = maskProps(headersToLowerCase(result.response.headers), sanitizeHeaders, {
      isHeaders: true
    });

    if (result.response.headers && Object.keys(result.response.headers).length === 0) {
      delete result.response;
    } else {
      // add response.timestamp (response Date header)
      try {
        if (result.response.headers.date) result.response.timestamp = new Date(result.response.headers.date).toISOString();
      } catch (err) {
        debug(err);
      } // add response.duration (parsed from response X-Response-Time header)


      try {
        if (result.response.headers['x-response-time']) {
          var duration = ms(result.response.headers['x-response-time']);
          if (typeof duration === 'number') result.response.duration = duration;
        }
      } catch (err) {
        debug(err);
      }
    }
  } // add request's id if available from `req.id`


  var requestId;

  if (ctx) {
    if (isString(ctx.id)) requestId = ctx.id;else if (isString(ctx.request.id)) requestId = ctx.request.id;else if (isString(ctx.req.id)) requestId = ctx.req.id;else if (isString(ctx.state.reqId)) requestId = ctx.state.reqId;else if (isString(ctx.state.id)) requestId = ctx.state.id;
  } else if (req && isString(req.id)) {
    requestId = req.id;
  } // TODO: we should probably validate this id somehow
  // (e.g. like we do with checking if cuid or uuid or objectid)


  if (requestId) result.request.id = requestId;else if (headers && headers['x-request-id']) result.request.id = headers['x-request-id']; // add httpVersion if possible (server-side only)

  var httpVersion = nodeReq.httpVersion,
      httpVersionMajor = nodeReq.httpVersionMajor,
      httpVersionMinor = nodeReq.httpVersionMinor;
  if (isString(httpVersion)) result.request.http_version = httpVersion;else if (typeof httpVersionMajor === 'number' && typeof httpVersionMinor === 'number' || isString(httpVersionMajor) && isString(httpVersionMinor)) result.request.http_version = "".concat(httpVersionMajor, ".").concat(httpVersionMinor); // parse `req.file` and `req.files` for multer v1.x and v2.x

  if (parseFiles && !nodeReq[disableFileParsingSymbol]) {
    // koa-multer@1.x binded to `ctx.req`
    // and then koa-multer was forked by @niftylettuce to @koajs/multer
    // and the 2.0.0 release changed it so it uses `ctx.file` and `ctx.files`
    // (so it doesn't bind to the `ctx.req` Node original request object
    // <https://github.com/koa-modules/multer/pull/15>
    var file;
    var files;

    if (ctx) {
      file = ctx.file || ctx.request.file || ctx.req.file;
      files = ctx.files || ctx.request.files || ctx.req.files;
    } else if (req) {
      file = req.file;
      files = req.files;
    }

    if (_typeof(file) === 'object') result.request.file = safeStringify(clone(maskSpecialTypes(file, maskSpecialTypesOptions)));
    if (_typeof(files) === 'object') result.request.files = safeStringify(clone(maskSpecialTypes(files, maskSpecialTypesOptions)));
  }

  result.duration = convertHrtime(hrtime(start)).milliseconds;
  return result;
};

module.exports = parseRequest;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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