function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

import { DiffPatcher } from "jsondiffpatch";
var diffPatcher = new DiffPatcher({
  arrays: {
    detectMove: false
  },
  textDiff: {
    minLength: 1
  }
});
self.addEventListener("message", function (e) {
  if (!e.data.id || !e.data.method || !e.data.args) {
    return;
  }

  switch (e.data.method) {
    case "diff":
      {
        var _e$data$args = _slicedToArray(e.data.args, 1),
            _e$data$args$ = _e$data$args[0],
            a = _e$data$args$.a,
            b = _e$data$args$.b,
            id = _e$data$args$.id;

        self.postMessage({
          id: e.data.id,
          returns: {
            id: id,
            delta: diffPatcher.diff(a, b)
          }
        });
        break;
      }

    default:
      throw new Error("unknown method", e.data.method);
  }
});