"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
var _jsUtilsJs = require("./utils/js_utils.js");
class EnterLeaveCounter {
    enter(enteringNode) {
        const previousLength = this.entered.length;
        const isNodeEntered = (node)=>this.isNodeInDocument(node) && (!node.contains || node.contains(enteringNode))
        ;
        this.entered = (0, _jsUtilsJs).union(this.entered.filter(isNodeEntered), [
            enteringNode
        ]);
        return previousLength === 0 && this.entered.length > 0;
    }
    leave(leavingNode) {
        const previousLength = this.entered.length;
        this.entered = (0, _jsUtilsJs).without(this.entered.filter(this.isNodeInDocument), leavingNode);
        return previousLength > 0 && this.entered.length === 0;
    }
    reset() {
        this.entered = [];
    }
    constructor(isNodeInDocument){
        this.entered = [];
        this.isNodeInDocument = isNodeInDocument;
    }
}
exports.EnterLeaveCounter = EnterLeaveCounter;

//# sourceMappingURL=EnterLeaveCounter.js.map