"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.createNativeDragSource = createNativeDragSource;
exports.matchNativeItemType = matchNativeItemType;
var _nativeTypesConfigJs = require("./nativeTypesConfig.js");
var _nativeDragSourceJs = require("./NativeDragSource.js");
function createNativeDragSource(type, dataTransfer) {
    const config = _nativeTypesConfigJs.nativeTypesConfig[type];
    if (!config) {
        throw new Error(`native type ${type} has no configuration`);
    }
    const result = new _nativeDragSourceJs.NativeDragSource(config);
    result.loadDataTransfer(dataTransfer);
    return result;
}
function matchNativeItemType(dataTransfer) {
    if (!dataTransfer) {
        return null;
    }
    const dataTransferTypes = Array.prototype.slice.call(dataTransfer.types || []);
    return Object.keys(_nativeTypesConfigJs.nativeTypesConfig).filter((nativeItemType)=>{
        const typeConfig = _nativeTypesConfigJs.nativeTypesConfig[nativeItemType];
        if (!(typeConfig === null || typeConfig === void 0 ? void 0 : typeConfig.matchesTypes)) {
            return false;
        }
        return typeConfig.matchesTypes.some((t)=>dataTransferTypes.indexOf(t) > -1
        );
    })[0] || null;
}

//# sourceMappingURL=index.js.map