"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.nativeTypesConfig = void 0;
var NativeTypes = _interopRequireWildcard(require("../NativeTypes.js"));
var _getDataFromDataTransferJs = require("./getDataFromDataTransfer.js");
function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
        return obj;
    } else {
        var newObj = {};
        if (obj != null) {
            for(var key in obj){
                if (Object.prototype.hasOwnProperty.call(obj, key)) {
                    var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};
                    if (desc.get || desc.set) {
                        Object.defineProperty(newObj, key, desc);
                    } else {
                        newObj[key] = obj[key];
                    }
                }
            }
        }
        newObj.default = obj;
        return newObj;
    }
}
const nativeTypesConfig = {
    [NativeTypes.FILE]: {
        exposeProperties: {
            files: (dataTransfer)=>Array.prototype.slice.call(dataTransfer.files)
            ,
            items: (dataTransfer)=>dataTransfer.items
            ,
            dataTransfer: (dataTransfer)=>dataTransfer
        },
        matchesTypes: [
            'Files'
        ]
    },
    [NativeTypes.HTML]: {
        exposeProperties: {
            html: (dataTransfer, matchesTypes)=>(0, _getDataFromDataTransferJs).getDataFromDataTransfer(dataTransfer, matchesTypes, '')
            ,
            dataTransfer: (dataTransfer)=>dataTransfer
        },
        matchesTypes: [
            'Html',
            'text/html'
        ]
    },
    [NativeTypes.URL]: {
        exposeProperties: {
            urls: (dataTransfer, matchesTypes)=>(0, _getDataFromDataTransferJs).getDataFromDataTransfer(dataTransfer, matchesTypes, '').split('\n')
            ,
            dataTransfer: (dataTransfer)=>dataTransfer
        },
        matchesTypes: [
            'Url',
            'text/uri-list'
        ]
    },
    [NativeTypes.TEXT]: {
        exposeProperties: {
            text: (dataTransfer, matchesTypes)=>(0, _getDataFromDataTransferJs).getDataFromDataTransfer(dataTransfer, matchesTypes, '')
            ,
            dataTransfer: (dataTransfer)=>dataTransfer
        },
        matchesTypes: [
            'Text',
            'text/plain'
        ]
    }
};
exports.nativeTypesConfig = nativeTypesConfig;

//# sourceMappingURL=nativeTypesConfig.js.map