"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeGeneratorResponse_File = exports.CodeGeneratorResponse = exports.CodeGeneratorRequest = exports.Version = exports.codeGeneratorResponse_FeatureToJSON = exports.codeGeneratorResponse_FeatureFromJSON = exports.CodeGeneratorResponse_Feature = void 0;
/* eslint-disable */
const Long = require("long");
const _m0 = require("protobufjs/minimal");
const descriptor_1 = require("../descriptor");
/** Sync with code_generator.h. */
var CodeGeneratorResponse_Feature;
(function (CodeGeneratorResponse_Feature) {
    CodeGeneratorResponse_Feature[CodeGeneratorResponse_Feature["FEATURE_NONE"] = 0] = "FEATURE_NONE";
    CodeGeneratorResponse_Feature[CodeGeneratorResponse_Feature["FEATURE_PROTO3_OPTIONAL"] = 1] = "FEATURE_PROTO3_OPTIONAL";
    CodeGeneratorResponse_Feature[CodeGeneratorResponse_Feature["UNRECOGNIZED"] = -1] = "UNRECOGNIZED";
})(CodeGeneratorResponse_Feature = exports.CodeGeneratorResponse_Feature || (exports.CodeGeneratorResponse_Feature = {}));
function codeGeneratorResponse_FeatureFromJSON(object) {
    switch (object) {
        case 0:
        case "FEATURE_NONE":
            return CodeGeneratorResponse_Feature.FEATURE_NONE;
        case 1:
        case "FEATURE_PROTO3_OPTIONAL":
            return CodeGeneratorResponse_Feature.FEATURE_PROTO3_OPTIONAL;
        case -1:
        case "UNRECOGNIZED":
        default:
            return CodeGeneratorResponse_Feature.UNRECOGNIZED;
    }
}
exports.codeGeneratorResponse_FeatureFromJSON = codeGeneratorResponse_FeatureFromJSON;
function codeGeneratorResponse_FeatureToJSON(object) {
    switch (object) {
        case CodeGeneratorResponse_Feature.FEATURE_NONE:
            return "FEATURE_NONE";
        case CodeGeneratorResponse_Feature.FEATURE_PROTO3_OPTIONAL:
            return "FEATURE_PROTO3_OPTIONAL";
        case CodeGeneratorResponse_Feature.UNRECOGNIZED:
        default:
            return "UNRECOGNIZED";
    }
}
exports.codeGeneratorResponse_FeatureToJSON = codeGeneratorResponse_FeatureToJSON;
function createBaseVersion() {
    return { major: 0, minor: 0, patch: 0, suffix: "" };
}
exports.Version = {
    encode(message, writer = _m0.Writer.create()) {
        if (message.major !== 0) {
            writer.uint32(8).int32(message.major);
        }
        if (message.minor !== 0) {
            writer.uint32(16).int32(message.minor);
        }
        if (message.patch !== 0) {
            writer.uint32(24).int32(message.patch);
        }
        if (message.suffix !== "") {
            writer.uint32(34).string(message.suffix);
        }
        if (message._unknownFields !== undefined) {
            for (const key in message._unknownFields) {
                const values = message._unknownFields[key];
                const tag = parseInt(key, 10);
                for (const value of values) {
                    writer.uint32(tag);
                    writer["_push"]((val, buf, pos) => buf.set(val, pos), value.length, value);
                }
            }
        }
        return writer;
    },
    decode(input, length) {
        const reader = input instanceof _m0.Reader ? input : _m0.Reader.create(input);
        let end = length === undefined ? reader.len : reader.pos + length;
        const message = Object.create(createBaseVersion());
        while (reader.pos < end) {
            const tag = reader.uint32();
            switch (tag >>> 3) {
                case 1:
                    if (tag != 8) {
                        break;
                    }
                    message.major = reader.int32();
                    continue;
                case 2:
                    if (tag != 16) {
                        break;
                    }
                    message.minor = reader.int32();
                    continue;
                case 3:
                    if (tag != 24) {
                        break;
                    }
                    message.patch = reader.int32();
                    continue;
                case 4:
                    if (tag != 34) {
                        break;
                    }
                    message.suffix = reader.string();
                    continue;
            }
            if ((tag & 7) == 4 || tag == 0) {
                break;
            }
            const startPos = reader.pos;
            reader.skipType(tag & 7);
            const buf = reader.buf.slice(startPos, reader.pos);
            if (message._unknownFields === undefined) {
                message._unknownFields = {};
            }
            const list = message._unknownFields[tag];
            if (list === undefined) {
                message._unknownFields[tag] = [buf];
            }
            else {
                list.push(buf);
            }
        }
        return message;
    },
    fromJSON(object) {
        return {
            major: isSet(object.major) ? Number(object.major) : 0,
            minor: isSet(object.minor) ? Number(object.minor) : 0,
            patch: isSet(object.patch) ? Number(object.patch) : 0,
            suffix: isSet(object.suffix) ? String(object.suffix) : "",
        };
    },
    toJSON(message) {
        const obj = {};
        message.major !== undefined && (obj.major = Math.round(message.major));
        message.minor !== undefined && (obj.minor = Math.round(message.minor));
        message.patch !== undefined && (obj.patch = Math.round(message.patch));
        message.suffix !== undefined && (obj.suffix = message.suffix);
        return obj;
    },
    create(base) {
        return exports.Version.fromPartial(base !== null && base !== void 0 ? base : {});
    },
    fromPartial(object) {
        var _a, _b, _c, _d;
        const message = Object.create(createBaseVersion());
        message.major = (_a = object.major) !== null && _a !== void 0 ? _a : 0;
        message.minor = (_b = object.minor) !== null && _b !== void 0 ? _b : 0;
        message.patch = (_c = object.patch) !== null && _c !== void 0 ? _c : 0;
        message.suffix = (_d = object.suffix) !== null && _d !== void 0 ? _d : "";
        return message;
    },
};
function createBaseCodeGeneratorRequest() {
    return { fileToGenerate: [], parameter: "", protoFile: [], compilerVersion: undefined };
}
exports.CodeGeneratorRequest = {
    encode(message, writer = _m0.Writer.create()) {
        for (const v of message.fileToGenerate) {
            writer.uint32(10).string(v);
        }
        if (message.parameter !== "") {
            writer.uint32(18).string(message.parameter);
        }
        for (const v of message.protoFile) {
            descriptor_1.FileDescriptorProto.encode(v, writer.uint32(122).fork()).ldelim();
        }
        if (message.compilerVersion !== undefined) {
            exports.Version.encode(message.compilerVersion, writer.uint32(26).fork()).ldelim();
        }
        if (message._unknownFields !== undefined) {
            for (const key in message._unknownFields) {
                const values = message._unknownFields[key];
                const tag = parseInt(key, 10);
                for (const value of values) {
                    writer.uint32(tag);
                    writer["_push"]((val, buf, pos) => buf.set(val, pos), value.length, value);
                }
            }
        }
        return writer;
    },
    decode(input, length) {
        const reader = input instanceof _m0.Reader ? input : _m0.Reader.create(input);
        let end = length === undefined ? reader.len : reader.pos + length;
        const message = Object.create(createBaseCodeGeneratorRequest());
        while (reader.pos < end) {
            const tag = reader.uint32();
            switch (tag >>> 3) {
                case 1:
                    if (tag != 10) {
                        break;
                    }
                    message.fileToGenerate.push(reader.string());
                    continue;
                case 2:
                    if (tag != 18) {
                        break;
                    }
                    message.parameter = reader.string();
                    continue;
                case 15:
                    if (tag != 122) {
                        break;
                    }
                    message.protoFile.push(descriptor_1.FileDescriptorProto.decode(reader, reader.uint32()));
                    continue;
                case 3:
                    if (tag != 26) {
                        break;
                    }
                    message.compilerVersion = exports.Version.decode(reader, reader.uint32());
                    continue;
            }
            if ((tag & 7) == 4 || tag == 0) {
                break;
            }
            const startPos = reader.pos;
            reader.skipType(tag & 7);
            const buf = reader.buf.slice(startPos, reader.pos);
            if (message._unknownFields === undefined) {
                message._unknownFields = {};
            }
            const list = message._unknownFields[tag];
            if (list === undefined) {
                message._unknownFields[tag] = [buf];
            }
            else {
                list.push(buf);
            }
        }
        return message;
    },
    fromJSON(object) {
        return {
            fileToGenerate: Array.isArray(object === null || object === void 0 ? void 0 : object.fileToGenerate) ? object.fileToGenerate.map((e) => String(e)) : [],
            parameter: isSet(object.parameter) ? String(object.parameter) : "",
            protoFile: Array.isArray(object === null || object === void 0 ? void 0 : object.protoFile)
                ? object.protoFile.map((e) => descriptor_1.FileDescriptorProto.fromJSON(e))
                : [],
            compilerVersion: isSet(object.compilerVersion) ? exports.Version.fromJSON(object.compilerVersion) : undefined,
        };
    },
    toJSON(message) {
        const obj = {};
        if (message.fileToGenerate) {
            obj.fileToGenerate = message.fileToGenerate.map((e) => e);
        }
        else {
            obj.fileToGenerate = [];
        }
        message.parameter !== undefined && (obj.parameter = message.parameter);
        if (message.protoFile) {
            obj.protoFile = message.protoFile.map((e) => e ? descriptor_1.FileDescriptorProto.toJSON(e) : undefined);
        }
        else {
            obj.protoFile = [];
        }
        message.compilerVersion !== undefined &&
            (obj.compilerVersion = message.compilerVersion ? exports.Version.toJSON(message.compilerVersion) : undefined);
        return obj;
    },
    create(base) {
        return exports.CodeGeneratorRequest.fromPartial(base !== null && base !== void 0 ? base : {});
    },
    fromPartial(object) {
        var _a, _b, _c;
        const message = Object.create(createBaseCodeGeneratorRequest());
        message.fileToGenerate = ((_a = object.fileToGenerate) === null || _a === void 0 ? void 0 : _a.map((e) => e)) || [];
        message.parameter = (_b = object.parameter) !== null && _b !== void 0 ? _b : "";
        message.protoFile = ((_c = object.protoFile) === null || _c === void 0 ? void 0 : _c.map((e) => descriptor_1.FileDescriptorProto.fromPartial(e))) || [];
        message.compilerVersion = (object.compilerVersion !== undefined && object.compilerVersion !== null)
            ? exports.Version.fromPartial(object.compilerVersion)
            : undefined;
        return message;
    },
};
function createBaseCodeGeneratorResponse() {
    return { error: "", supportedFeatures: 0, file: [] };
}
exports.CodeGeneratorResponse = {
    encode(message, writer = _m0.Writer.create()) {
        if (message.error !== "") {
            writer.uint32(10).string(message.error);
        }
        if (message.supportedFeatures !== 0) {
            writer.uint32(16).uint64(message.supportedFeatures);
        }
        for (const v of message.file) {
            exports.CodeGeneratorResponse_File.encode(v, writer.uint32(122).fork()).ldelim();
        }
        if (message._unknownFields !== undefined) {
            for (const key in message._unknownFields) {
                const values = message._unknownFields[key];
                const tag = parseInt(key, 10);
                for (const value of values) {
                    writer.uint32(tag);
                    writer["_push"]((val, buf, pos) => buf.set(val, pos), value.length, value);
                }
            }
        }
        return writer;
    },
    decode(input, length) {
        const reader = input instanceof _m0.Reader ? input : _m0.Reader.create(input);
        let end = length === undefined ? reader.len : reader.pos + length;
        const message = Object.create(createBaseCodeGeneratorResponse());
        while (reader.pos < end) {
            const tag = reader.uint32();
            switch (tag >>> 3) {
                case 1:
                    if (tag != 10) {
                        break;
                    }
                    message.error = reader.string();
                    continue;
                case 2:
                    if (tag != 16) {
                        break;
                    }
                    message.supportedFeatures = longToNumber(reader.uint64());
                    continue;
                case 15:
                    if (tag != 122) {
                        break;
                    }
                    message.file.push(exports.CodeGeneratorResponse_File.decode(reader, reader.uint32()));
                    continue;
            }
            if ((tag & 7) == 4 || tag == 0) {
                break;
            }
            const startPos = reader.pos;
            reader.skipType(tag & 7);
            const buf = reader.buf.slice(startPos, reader.pos);
            if (message._unknownFields === undefined) {
                message._unknownFields = {};
            }
            const list = message._unknownFields[tag];
            if (list === undefined) {
                message._unknownFields[tag] = [buf];
            }
            else {
                list.push(buf);
            }
        }
        return message;
    },
    fromJSON(object) {
        return {
            error: isSet(object.error) ? String(object.error) : "",
            supportedFeatures: isSet(object.supportedFeatures) ? Number(object.supportedFeatures) : 0,
            file: Array.isArray(object === null || object === void 0 ? void 0 : object.file) ? object.file.map((e) => exports.CodeGeneratorResponse_File.fromJSON(e)) : [],
        };
    },
    toJSON(message) {
        const obj = {};
        message.error !== undefined && (obj.error = message.error);
        message.supportedFeatures !== undefined && (obj.supportedFeatures = Math.round(message.supportedFeatures));
        if (message.file) {
            obj.file = message.file.map((e) => e ? exports.CodeGeneratorResponse_File.toJSON(e) : undefined);
        }
        else {
            obj.file = [];
        }
        return obj;
    },
    create(base) {
        return exports.CodeGeneratorResponse.fromPartial(base !== null && base !== void 0 ? base : {});
    },
    fromPartial(object) {
        var _a, _b, _c;
        const message = Object.create(createBaseCodeGeneratorResponse());
        message.error = (_a = object.error) !== null && _a !== void 0 ? _a : "";
        message.supportedFeatures = (_b = object.supportedFeatures) !== null && _b !== void 0 ? _b : 0;
        message.file = ((_c = object.file) === null || _c === void 0 ? void 0 : _c.map((e) => exports.CodeGeneratorResponse_File.fromPartial(e))) || [];
        return message;
    },
};
function createBaseCodeGeneratorResponse_File() {
    return { name: "", insertionPoint: "", content: "", generatedCodeInfo: undefined };
}
exports.CodeGeneratorResponse_File = {
    encode(message, writer = _m0.Writer.create()) {
        if (message.name !== "") {
            writer.uint32(10).string(message.name);
        }
        if (message.insertionPoint !== "") {
            writer.uint32(18).string(message.insertionPoint);
        }
        if (message.content !== "") {
            writer.uint32(122).string(message.content);
        }
        if (message.generatedCodeInfo !== undefined) {
            descriptor_1.GeneratedCodeInfo.encode(message.generatedCodeInfo, writer.uint32(130).fork()).ldelim();
        }
        if (message._unknownFields !== undefined) {
            for (const key in message._unknownFields) {
                const values = message._unknownFields[key];
                const tag = parseInt(key, 10);
                for (const value of values) {
                    writer.uint32(tag);
                    writer["_push"]((val, buf, pos) => buf.set(val, pos), value.length, value);
                }
            }
        }
        return writer;
    },
    decode(input, length) {
        const reader = input instanceof _m0.Reader ? input : _m0.Reader.create(input);
        let end = length === undefined ? reader.len : reader.pos + length;
        const message = Object.create(createBaseCodeGeneratorResponse_File());
        while (reader.pos < end) {
            const tag = reader.uint32();
            switch (tag >>> 3) {
                case 1:
                    if (tag != 10) {
                        break;
                    }
                    message.name = reader.string();
                    continue;
                case 2:
                    if (tag != 18) {
                        break;
                    }
                    message.insertionPoint = reader.string();
                    continue;
                case 15:
                    if (tag != 122) {
                        break;
                    }
                    message.content = reader.string();
                    continue;
                case 16:
                    if (tag != 130) {
                        break;
                    }
                    message.generatedCodeInfo = descriptor_1.GeneratedCodeInfo.decode(reader, reader.uint32());
                    continue;
            }
            if ((tag & 7) == 4 || tag == 0) {
                break;
            }
            const startPos = reader.pos;
            reader.skipType(tag & 7);
            const buf = reader.buf.slice(startPos, reader.pos);
            if (message._unknownFields === undefined) {
                message._unknownFields = {};
            }
            const list = message._unknownFields[tag];
            if (list === undefined) {
                message._unknownFields[tag] = [buf];
            }
            else {
                list.push(buf);
            }
        }
        return message;
    },
    fromJSON(object) {
        return {
            name: isSet(object.name) ? String(object.name) : "",
            insertionPoint: isSet(object.insertionPoint) ? String(object.insertionPoint) : "",
            content: isSet(object.content) ? String(object.content) : "",
            generatedCodeInfo: isSet(object.generatedCodeInfo)
                ? descriptor_1.GeneratedCodeInfo.fromJSON(object.generatedCodeInfo)
                : undefined,
        };
    },
    toJSON(message) {
        const obj = {};
        message.name !== undefined && (obj.name = message.name);
        message.insertionPoint !== undefined && (obj.insertionPoint = message.insertionPoint);
        message.content !== undefined && (obj.content = message.content);
        message.generatedCodeInfo !== undefined && (obj.generatedCodeInfo = message.generatedCodeInfo
            ? descriptor_1.GeneratedCodeInfo.toJSON(message.generatedCodeInfo)
            : undefined);
        return obj;
    },
    create(base) {
        return exports.CodeGeneratorResponse_File.fromPartial(base !== null && base !== void 0 ? base : {});
    },
    fromPartial(object) {
        var _a, _b, _c;
        const message = Object.create(createBaseCodeGeneratorResponse_File());
        message.name = (_a = object.name) !== null && _a !== void 0 ? _a : "";
        message.insertionPoint = (_b = object.insertionPoint) !== null && _b !== void 0 ? _b : "";
        message.content = (_c = object.content) !== null && _c !== void 0 ? _c : "";
        message.generatedCodeInfo = (object.generatedCodeInfo !== undefined && object.generatedCodeInfo !== null)
            ? descriptor_1.GeneratedCodeInfo.fromPartial(object.generatedCodeInfo)
            : undefined;
        return message;
    },
};
var tsProtoGlobalThis = (() => {
    if (typeof globalThis !== "undefined") {
        return globalThis;
    }
    if (typeof self !== "undefined") {
        return self;
    }
    if (typeof window !== "undefined") {
        return window;
    }
    if (typeof global !== "undefined") {
        return global;
    }
    throw "Unable to locate global object";
})();
function longToNumber(long) {
    if (long.gt(Number.MAX_SAFE_INTEGER)) {
        throw new tsProtoGlobalThis.Error("Value is larger than Number.MAX_SAFE_INTEGER");
    }
    return long.toNumber();
}
// If you get a compile-error about 'Constructor<Long> and ... have no overlap',
// add '--ts_proto_opt=esModuleInterop=true' as a flag when calling 'protoc'.
if (_m0.util.Long !== Long) {
    _m0.util.Long = Long;
    _m0.configure();
}
function isSet(value) {
    return value !== null && value !== undefined;
}
